define([
    'jquery',
    'uiRegistry',
    'mage/utils/wrapper',
    'Swissup_AddressValidation/js/validation-result'
], function ($, registry, wrapper, validationResult) {
    'use strict';

    var checkoutConfig = window.checkoutConfig;

    /**
     * @param  {Object} target
     * @return {Object}
     */
    return function (target) {
        if (!checkoutConfig) {
            return target;
        }

        target = wrapper.wrap(
            target,
            function (o, payload) {
                o(payload);

                if (validationResult.getSelectedOption() === 'skip') {
                    //jscs:disable requireCamelCaseOrUpperCaseIdentifiers
                    if (!payload.addressInformation.shipping_address.extensionAttributes) {
                        payload.addressInformation.shipping_address.extensionAttributes = {};
                    }

                    payload.addressInformation.shipping_address.extensionAttributes.swissup_validation = 'skip';
                    //jscs:enable requireCamelCaseOrUpperCaseIdentifiers
                }

                return payload;
            }
        );

        return target;
    };
});
