<?php

namespace Swissup\AddressValidation\Model;

use Swissup\AddressValidation\Model\Service\ServiceInterface;

class Validator
{
    private $serviceProvider;

    public function __construct(ServiceProvider $serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
    }

    public function validate(\Magento\Quote\Api\Data\AddressInterface $address): Result
    {
        return $this->serviceProvider->getService()->validate($address);
    }

    public function canValidate(\Magento\Quote\Api\Data\AddressInterface $address): bool
    {
        return $this->serviceProvider->getService()->canValidate($address);
    }
}
