define([
    'mage/utils/wrapper',
    'Swissup_AddressValidation/js/validation-result'
], function (wrapper, validationResult) {
    'use strict';

    var checkoutConfig = window.checkoutConfig;

    function parseAddressValidationResponse(response) {
        var data;

        if (response.responseText.indexOf('swissup_address_validation') === -1) {
            return;
        }

        try {
            data = JSON.parse(response.responseText);

            if (data.message && data.message.indexOf('swissup_address_validation') > 0) {
                return JSON.parse(data.message).data;
            }
        } catch (e) {
            console.error(e);
        }
    }

    return function (target) {
        if (!checkoutConfig) {
            return target;
        }

        target.process = wrapper.wrap(
            target.process,
            function (original, response, messageContainer) {
                var data = parseAddressValidationResponse(response);

                if (data) {
                    return validationResult.processResult(data);
                }

                return original(response, messageContainer);
            }
        );

        return target;
    };
});
