<?php

namespace Swissup\AddressValidation\Plugin;

use Magento\Checkout\Model\ShippingInformationManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;

class ValidateShippingAddress
{
    private $helper;

    private $validator;

    public function __construct(
        \Swissup\AddressValidation\Helper\Data $helper,
        \Swissup\AddressValidation\Model\Validator $validator
    ) {
        $this->helper = $helper;
        $this->validator = $validator;
    }

    public function beforeSaveAddressInformation(
        ShippingInformationManagement $subject,
        $cartId,
        ShippingInformationInterface $addressInformation
    ) {
        $address = $addressInformation->getShippingAddress();

        if (!$this->helper->isEnabled() ||
            $address->getCustomerAddressId() ||
            $address->getShouldIgnoreValidation() ||
            !$this->validator->canValidate($address)
        ) {
            return;
        }

        try {
            $result = $this->validator->validate($address);
        } catch (\Exception $e) {
            // service was not able to validate address for some reason.
            return;
        }

        if ($result->isValid()) {
            return;
        }

        $result = [
            'swissup_address_validation' => true,
            'data' => [
                'error' => $result->getError(),
                'original' => $result->getOriginalData(),
                'suggestions' => $result->getSuggestions(),
                'autocorrect' => $this->helper->isAutocorrectionEnabled() ?
                    $result->getAutocorrect() : [],
            ],
        ];

        throw new \Exception(json_encode($result));
    }
}
