<?php

namespace Swissup\AddressValidation\Model;

class Result
{
    private $isValid = true;

    private $error = '';

    private $originalData = [];

    private $suggestions = [];

    private $autocorrect = [];

    public function isValid(): bool
    {
        return $this->isValid;
    }

    public function getOriginalData(): array
    {
        return $this->originalData;
    }

    public function getError(): string
    {
        return $this->error;
    }

    public function getSuggestions(): array
    {
        return $this->suggestions;
    }

    public function getAutocorrect(): array
    {
        return $this->autocorrect;
    }

    public function setIsValid(bool $flag)
    {
        $this->isValid = $flag;

        return $this;
    }

    public function setOriginalData(array $data)
    {
        $this->originalData = $data;

        return $this;
    }

    public function setError(string $error)
    {
        $this->error = $error;

        return $this;
    }

    public function setSuggestions(array $suggestions)
    {
        $this->suggestions = $suggestions;

        return $this;
    }

    public function setAutocorrect(array $autocorrect)
    {
        $this->autocorrect = $autocorrect;

        return $this;
    }
}
