<?php

namespace Swissup\AddressValidation\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper
{
    public function isEnabled(): bool
    {
        return (bool) $this->getConfigValue('swissup_address_validation/general/enabled');
    }

    public function isAutocorrectionEnabled(): bool
    {
        return (bool) $this->getConfigValue('swissup_address_validation/general/autocorrection');
    }

    public function getConfigValue(string $path, string $scope = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->getValue($path, $scope);
    }
}
