<?php

/**
 * PAYONE Magento 2 Connector is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PAYONE Magento 2 Connector is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with PAYONE Magento 2 Connector. If not, see <http://www.gnu.org/licenses/>.
 *
 * PHP version 5
 *
 * @category  Payone
 * @package   Payone_Magento2_Plugin
 * @author    FATCHIP GmbH <support@fatchip.de>
 * @copyright 2003 - 2016 Payone GmbH
 * @license   <http://www.gnu.org/licenses/> GNU Lesser General Public License
 * @link      http://www.payone.de
 */

namespace Payone\Core\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Payone\Core\Helper\Toolkit;
use Magento\Payment\Model\InfoInterface;

/**
 * Event class to set the orderstatus to new and pending
 */
class PaymentMethodAssignData implements ObserverInterface
{
    /**
     * PAYONE toolkit helper
     *
     * @var \Payone\Core\Helper\Toolkit
     */
    protected $toolkitHelper;

    /**
     * Constructor
     *
     * @param Toolkit $toolkitHelper
     */
    public function __construct(Toolkit $toolkitHelper)
    {
        $this->toolkitHelper = $toolkitHelper;
    }

    /**
     * Execute certain tasks after the payment is placed and thus the order is placed
     *
     * @param  Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        $blBoniAgreement = $this->toolkitHelper->getAdditionalDataEntry($observer->getData('data'), 'payone_boni_agreement');
        if ($blBoniAgreement !== null) {
            /** @var InfoInterface $oPaymentInfo */
            $oPaymentInfo = $observer->getPaymentModel();
            $oPaymentInfo->setAdditionalInformation('payone_boni_agreement', (bool)$blBoniAgreement);
        }
    }
}
