<?php

/**
 * PAYONE Magento 2 Connector is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PAYONE Magento 2 Connector is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with PAYONE Magento 2 Connector. If not, see <http://www.gnu.org/licenses/>.
 *
 * PHP version 5
 *
 * @category  Payone
 * @package   Payone_Magento2_Plugin
 * @author    FATCHIP GmbH <support@fatchip.de>
 * @copyright 2003 - 2020 Payone GmbH
 * @license   <http://www.gnu.org/licenses/> GNU Lesser General Public License
 * @link      http://www.payone.de
 */

namespace Payone\Core\Block;

use Magento\Framework\View\Element\Template;
use Payone\Core\Model\PayoneConfig;

class RatepayDeviceFingerprint extends Template
{
    /**
     * @var \Payone\Core\Helper\Ratepay
     */
    protected $ratepayHelper;

    /**
     * @var \Payone\Core\Helper\Payment
     */
    protected $paymentHelper;

    /**
     * Constructor
     *
     * @param Template\Context              $context
     * @param \Payone\Core\Helper\Ratepay   $ratepayHelper
     * @param \Payone\Core\Helper\Payment   $paymentHelper
     * @param array                         $data
     */
    public function __construct(
        Template\Context $context,
        \Payone\Core\Helper\Ratepay $ratepayHelper,
        \Payone\Core\Helper\Payment $paymentHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->ratepayHelper = $ratepayHelper;
        $this->paymentHelper = $paymentHelper;
    }

    /**
     * Returns snippet id from config
     *
     * @return string
     */
    public function getDevicefingerprintSnippetId()
    {
        return $this->ratepayHelper->getConfigParam('devicefingerprint_snippet_id', 'ratepay', 'payone_misc');
    }

    /**
     * Returns token generated by Ratepay helper
     *
     * @return string
     */
    public function getDevicefingerprintToken()
    {
        return $this->ratepayHelper->getRatepayDeviceFingerprintToken();
    }

    /**
     * Determine if at least one of the three Ratepay methods is activated
     *
     * @return false
     */
    protected function isRatepayMethodActive()
    {
        if ($this->paymentHelper->isPaymentMethodActive(PayoneConfig::METHOD_RATEPAY_INVOICE) === true ||
            $this->paymentHelper->isPaymentMethodActive(PayoneConfig::METHOD_RATEPAY_DEBIT) === true ||
            $this->paymentHelper->isPaymentMethodActive(PayoneConfig::METHOD_RATEPAY_INSTALLMENT) === true
        ) {
            return true;
        }
        return false;
    }

    /**
     * Render block HTML
     *
     * @return string
     */
    protected function _toHtml()
    {
        if ($this->isRatepayMethodActive() === false) {
            return '';
        }
        return parent::_toHtml();
    }
}
