<?php

/**
 * PAYONE Magento 2 Connector is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PAYONE Magento 2 Connector is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with PAYONE Magento 2 Connector. If not, see <http://www.gnu.org/licenses/>.
 *
 * PHP version 5
 *
 * @category  Payone
 * @package   Payone_Magento2_Plugin
 * @author    FATCHIP GmbH <support@fatchip.de>
 * @copyright 2003 - 2020 Payone GmbH
 * @license   <http://www.gnu.org/licenses/> GNU Lesser General Public License
 * @link      http://www.payone.de
 */

namespace Payone\Core\Block\Adminhtml\Config\Form\Field;

/**
 * Admin-block for the Ratepay refresh profile button
 */
class RefreshRatepayProfiles extends \Magento\Config\Block\System\Config\Form\Field
{
    /**
     * Set template to itself
     *
     * @return \Payone\Core\Block\Adminhtml\Config\Form\Field\AmazonConfiguration
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if (!$this->getTemplate()) {
            $this->setTemplate('system/config/form/field/refresh_ratepay_profiles.phtml');
        }
        return $this;
    }

    /**
     * Generates unique javascript function name for each payment method
     *
     * @param  string $sPaymentMethod
     * @return string
     */
    protected function getJSFunctionName($sPaymentMethod)
    {
        $sPaymentMethod = ucwords($sPaymentMethod, "_");
        $sPaymentMethod = str_replace("_", "", $sPaymentMethod);
        return "updateProfileConfigs".$sPaymentMethod;
    }

    /**
     * Unset some non-related element parameters
     *
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     */
    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * Get the button and scripts contents
     *
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $sPaymentMethod = str_replace('payone_payment/', '', $originalData['path']);

        $this->addData([
            'ajax_url' => $this->_urlBuilder->getUrl('payone/config_ratepay/refresh', ['method' => $sPaymentMethod]),
            'javascript_function_name' => $this->getJSFunctionName($sPaymentMethod),
        ]);

        return $this->_toHtml();
    }
}
