<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
namespace MageWorx\SeoXTemplates\Setup\Patch\Data;

use Magento\Catalog\Model\Category;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;

class UpdateAttributeNotes implements DataPatchInterface, PatchVersionInterface
{
    /**
     * @var CategorySetupFactory
     */
    protected $categorySetupFactory;

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param CategorySetupFactory $categorySetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        CategorySetupFactory $categorySetupFactory
    ) {
        $this->moduleDataSetup      = $moduleDataSetup;
        $this->categorySetupFactory = $categorySetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $categorySetup = $this->categorySetupFactory->create(['setup' => $this->moduleDataSetup]);

        $categoryModifiedAttributes = [
            'meta_title',
            'meta_description',
            'meta_keywords',
            'description',
            'category_seo_name'
        ];

        $this->addNoteToAttributes($categorySetup, $categoryModifiedAttributes, Category::ENTITY);

        $productModifiedAttributes = [
            'meta_title',
            'meta_description',
            'meta_keyword',
            'description',
            'short_description',
            'url_key',
            'product_seo_name'
        ];

        $this->addNoteToAttributes($categorySetup, $productModifiedAttributes, Product::ENTITY);
    }

    /**
     * @param \Magento\Catalog\Setup\CategorySetup $categorySetup
     * @param array $attributes
     * @param $entity
     * @return void
     */
    protected function addNoteToAttributes($categorySetup, array $attributes, $entity) {
        foreach ($attributes as $attribute) {
            $categorySetup->updateAttribute(
                $entity,
                $attribute,
                'note',
                'Note: Switch to a store view level to see the "'. $attribute . '" attribute generated by MageWorx templates.'
            );
        }
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [
            \MageWorx\SeoXTemplates\Setup\Patch\Data\AddSeoNameAttributes::class
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }

    public static function getVersion()
    {
        return '2.0.3';
    }
}
