<?php
/**
 * Copyright © 2017 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\SeoRedirects\Api\Data;

/**
 * @api
 */
interface CustomRedirectInterface
{
    /**
     * Constants for keys of data array. Identical to the name of the getter in snake case
     */
    const REDIRECT_ID               = 'redirect_id';
    const REDIRECT_CODE             = 'redirect_code';
    const REQUEST_ENTITY_TYPE       = 'request_entity_type';
    const TARGET_ENTITY_TYPE        = 'target_entity_type';
    const REQUEST_ENTITY_IDENTIFIER = 'request_entity_identifier';
    const TARGET_ENTITY_IDENTIFIER  = 'target_entity_identifier';
    const STORE_ID                  = 'store_id';
    const DATE_CREATED              = 'date_created';
    const DATE_MODIFIED             = 'date_modified';
    const IS_AUTOGENERATED          = 'is_autogenerated';
    const IS_IMPORTED               = 'is_imported';
    const STATUS                    = 'status';
    const START_AT                  = 'start_at';
    const FINISH_AT                 = 'finish_at';

    /**
     * Get Redirect ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * @return string
     */
    public function getRedirectCode();

    /**
     * Get Request Entity Type
     *
     * @return string
     */
    public function getRequestEntityType();

    /**
     * Get Target Entity Type
     *
     * @return int
     */
    public function getTargetEntityType();

    /**
     * Get Request Entity Identifier
     *
     * @return int
     */
    public function getRequestEntityIdentifier();

    /**
     * Get Target Entity Identifier
     *
     * @return string
     */
    public function getTargetEntityIdentifier();

    /**
     * Get Redirect Store ID
     *
     * @return int
     */
    public function getStoreId();

    /**
     * Get Redirect Data Created
     *
     * @return string
     */
    public function getDateCreated();

    /**
     * Get Redirect Data Modified
     *
     * @return string
     */
    public function getDateModified();

    /**
     * Check if redirect is autogenereated
     *
     * @return int
     */
    public function getIsAutogenerated();

    /**
     * Check if redirect is imported
     *
     * @return bool
     */
    public function getIsImported();

    /**
     * Get Status
     *
     * @return int
     */
    public function getStatus();

    /**
     * Get Redirect Active From
     *
     * @return int
     */
    public function getStartAt();

    /**
     * Get Redirect Active To
     *
     * @return int
     */
    public function getFinishAt();

    /**
     * Set Redirect ID
     *
     * @param int $id
     * @return CustomRedirectInterface
     */
    public function setId($id);

    /**
     * @param int $code
     * @return CustomRedirectInterface
     */
    public function setRedirectCode($code);

    /**
     * Set Request Entity Type
     *
     * @param string $type
     * @return CustomRedirectInterface
     */
    public function setRequestEntityType($type);

    /**
     * Set Target Entity Type
     *
     * @param string $type
     * @return CustomRedirectInterface
     */
    public function setTargetEntityType($type);

    /**
     * Set Request Entity Identifier
     *
     * @param string $identifier
     * @return CustomRedirectInterface
     */
    public function setRequestEntityIdentifier($identifier);

    /**
     * Set Target Entity Identifier
     *
     * @param string $identifier
     * @return CustomRedirectInterface
     */
    public function setTargetEntityIdentifier($identifier);

    /**
     * Set Redirect Store ID
     *
     * @param int $storeId
     * @return CustomRedirectInterface
     */
    public function setStoreId($storeId);

    /**
     * Set Redirect Data Created
     *
     * @param string $date
     * @return CustomRedirectInterface
     */
    public function setDateCreated($date);

    /**
     * Set Redirect Data Modified
     *
     * @param string $date
     * @return CustomRedirectInterface
     */
    public function setDateModified($date);

    /**
     * Set that redirect is autogenereated
     *
     * @param int $isAutogenerated
     * @return int
     */
    public function setIsAutogenerated($isAutogenerated);

    /**
     * Set that redirect is imported
     *
     * @param bool $isImported
     * @return CustomRedirectInterface
     */
    public function setIsImported($isImported);

    /**
     * Set Redirect Status
     *
     * @param int $statusCode
     * @return CustomRedirectInterface
     */
    public function setStatus($statusCode);

    /**
     * Set Active From
     *
     * @param string $time
     * @return CustomRedirectInterface
     */
    public function setStartAt($time);

    /**
     * Set Active To
     *
     * @param string $time
     * @return CustomRedirectInterface
     */
    public function setFinishAt($time);


}
