<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Totals\Setup\Patch\Schema;

use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Magento\Framework\Setup\Patch\SchemaPatchInterface;

class AddQuoteIdForeignKey implements SchemaPatchInterface, PatchVersionInterface
{
    /**
     * @var SchemaSetupInterface
     */
    private $schemaSetup;

    /**
     * @param SchemaSetupInterface $schemaSetup
     */
    public function __construct(
        SchemaSetupInterface $schemaSetup
    ) {
        $this->schemaSetup = $schemaSetup;
    }

    /*
     * We are adding foreign key constraints for fooman_totals_quote_address to quote and quote_address
     * in the 10.2.0 release. To cater for existing entries that no longer have a corresponding entry
     * we delete them here first.
     */
    public function apply()
    {
        $this->schemaSetup->startSetup();
        $tableName = $this->schemaSetup->getTable('fooman_totals_quote_address');

        $select = $this->schemaSetup->getConnection()->select()
            ->from(['ftqa' => $tableName])
            ->joinLeft(
                ['quote' => $this->schemaSetup->getTable('quote')],
                'ftqa.quote_id = quote.entity_id'
            )->where('quote.entity_id IS NULL')
            ->columns(['entity_id']);

        $quoteIds = $this->schemaSetup->getConnection()->fetchCol($select);

        $select = $this->schemaSetup->getConnection()->select()
            ->from(['ftqa' => $tableName])
            ->joinLeft(
                ['quote_address' => $this->schemaSetup->getTable('quote_address')],
                'ftqa.quote_address_id = quote_address.address_id'
            )->where('quote_address.address_id IS NULL')
            ->columns(['entity_id']);

        $addressIds = $this->schemaSetup->getConnection()->fetchCol($select);
        $ids = array_unique(array_merge($quoteIds, $addressIds));
        $this->schemaSetup->getConnection()->delete($tableName, ['entity_id in (?)' => $ids]);

        $this->schemaSetup->endSetup();
        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getVersion()
    {
        return '10.2.0';
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
