<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Totals\Plugin;

use Fooman\Totals\Model\CreditmemoTotalManagement;
use Fooman\Totals\Model\GroupFactory;
use Magento\Sales\Api\CreditmemoRepositoryInterface;
use Magento\Sales\Api\Data\CreditmemoExtensionFactory;
use Magento\Sales\Api\Data\CreditmemoInterface;
use Magento\Sales\Api\Data\CreditmemoSearchResultInterface;

class CreditmemoRepository
{

    /**
     * @var CreditmemoTotalManagement
     */
    private $creditmemoTotalManagement;

    /**
     * @var CreditmemoExtensionFactory
     */
    private $creditmemoExtensionFactory;

    /**
     * @var GroupFactory
     */
    private $creditmemoTotalGroupFactory;

    /**
     * @param CreditmemoTotalManagement     $creditmemoTotalManagement
     * @param CreditmemoExtensionFactory $creditmemoExtensionFactory
     * @param GroupFactory               $creditmemoTotalGroupFactory
     */
    public function __construct(
        CreditmemoTotalManagement $creditmemoTotalManagement,
        CreditmemoExtensionFactory $creditmemoExtensionFactory,
        GroupFactory $creditmemoTotalGroupFactory
    ) {
        $this->creditmemoTotalManagement = $creditmemoTotalManagement;
        $this->creditmemoExtensionFactory = $creditmemoExtensionFactory;
        $this->creditmemoTotalGroupFactory = $creditmemoTotalGroupFactory;
    }

    /**
     * @param  CreditmemoRepositoryInterface $subject
     * @param  CreditmemoInterface      $creditmemo
     *
     * @return CreditmemoInterface      $creditmemo
     */
    public function afterGet(
        CreditmemoRepositoryInterface $subject,
        CreditmemoInterface $creditmemo
    ) {
        $this->applyExtensionAttributes($creditmemo);
        return $creditmemo;
    }

    /**
     * @param  CreditmemoRepositoryInterface $subject
     * @param CreditmemoSearchResultInterface $result
     *
     * @return CreditmemoSearchResultInterface
     */
    public function afterGetList(
        CreditmemoRepositoryInterface $subject,
        CreditmemoSearchResultInterface $result
    ) {
        $creditmemos = $result->getItems();
        if (!empty($creditmemos)) {
            foreach ($creditmemos as $creditmemo) {
                $this->applyExtensionAttributes($creditmemo);
            }
        }

        return $result;
    }

    /**
     * @param CreditmemoInterface $creditmemo
     *
     * @return void
     */
    private function applyExtensionAttributes(CreditmemoInterface $creditmemo)
    {
        $extensionAttributes = $creditmemo->getExtensionAttributes();
        if (!$extensionAttributes) {
            $extensionAttributes = $this->creditmemoExtensionFactory->create();
        }

        $foomanTotalGroup = $extensionAttributes->getFoomanTotalGroup();
        if (!$foomanTotalGroup) {
            $foomanTotalGroup = $this->creditmemoTotalGroupFactory->create();
        }

        //totals have already been added via collection load
        if (count($foomanTotalGroup->getItems())) {
            return;
        }

        $creditmemoTotals = $this->creditmemoTotalManagement->getByCreditmemoId(
            $creditmemo->getEntityId()
        );

        if (!empty($creditmemoTotals)) {
            foreach ($creditmemoTotals as $creditmemoTotal) {
                $foomanTotalGroup->addItem($creditmemoTotal);
            }
        }

        $extensionAttributes->setFoomanTotalGroup($foomanTotalGroup);
        $creditmemo->setExtensionAttributes($extensionAttributes);
    }
}
