<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Totals\Plugin;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Api\CartTotalRepositoryInterface;
use Magento\Quote\Api\Data\TotalsInterface;

class CartTotalGet
{
    /**
     * Quote repository.
     *
     * @var CartRepositoryInterface
     */
    private $quoteRepository;

    /**
     * @var Registry
     */
    private $registry;

    /**
     * @param CartRepositoryInterface $quoteRepository
     * @param Registry                $registry
     */
    public function __construct(
        CartRepositoryInterface $quoteRepository,
        Registry $registry
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->registry = $registry;
    }

    /**
     * Workaround for Magento\Quote\Model\Cart\CartTotalRepository attempting to copy
     * extension attributes of incompatible types.
     *
     * @param  CartTotalRepositoryInterface $subject
     * @param  \Closure                                        $proceed
     * @param  int                                             $cartId
     *
     * @return TotalsInterface Quote totals data.
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @throws NoSuchEntityException
     */
    public function aroundGet(
        CartTotalRepositoryInterface $subject,
        \Closure $proceed,
        $cartId
    ) {
        $quote = $this->quoteRepository->getActive($cartId);
        if ($quote->isVirtual()) {
            $extensionAttributes = $quote->getBillingAddress()->getExtensionAttributes();
            $quote->getBillingAddress()->unsExtensionAttributes();
        } else {
            $extensionAttributes = $quote->getShippingAddress()->getExtensionAttributes();
            $quote->getShippingAddress()->unsExtensionAttributes();
        }

        $this->registry->register('fooman_totals_quote_address_extension_attributes', $extensionAttributes);
        /** @var TotalsInterface $result */
        $result = $proceed($cartId);
        $this->registry->unregister('fooman_totals_quote_address_extension_attributes');
        if ($extensionAttributes) {
            if ($quote->isVirtual()) {
                $quote->getBillingAddress()->setExtensionAttributes($extensionAttributes);
            } else {
                $quote->getShippingAddress()->setExtensionAttributes($extensionAttributes);
            }
        }

        return $result;
    }
}
