<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Totals\Observer;

use Fooman\Totals\Model\GroupFactory;
use Fooman\Totals\Model\OrderTotalManagement;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Sales\Api\Data\OrderExtensionFactory;
use Magento\Sales\Api\Data\OrderInterface;

class OrderCollectionLoadAfter implements ObserverInterface
{

    /**
     * @var OrderTotalManagement
     */
    private $orderTotalManagement;

    /**
     * @var OrderExtensionFactory
     */
    private $orderExtensionFactory;

    /**
     * @var GroupFactory
     */
    private $orderTotalGroupFactory;

    /**
     * @param OrderTotalManagement $orderTotalManagement
     * @param OrderExtensionFactory $orderExtensionFactory
     * @param GroupFactory $orderTotalGroupFactory
     */
    public function __construct(
        OrderTotalManagement $orderTotalManagement,
        OrderExtensionFactory $orderExtensionFactory,
        GroupFactory $orderTotalGroupFactory
    ) {
        $this->orderTotalManagement = $orderTotalManagement;
        $this->orderExtensionFactory = $orderExtensionFactory;
        $this->orderTotalGroupFactory = $orderTotalGroupFactory;
    }

    /**
     * @param EventObserver $observer
     *
     * @return void
     * @throws \Exception
     */
    public function execute(EventObserver $observer)
    {
        $collection = $observer->getEvent()->getOrderCollection();
        foreach ($collection as $order) {
            $this->applyExtensionAttributes($order);
        }
    }

    private function applyExtensionAttributes(OrderInterface $order)
    {
        $extensionAttributes = $order->getExtensionAttributes();
        if (!$extensionAttributes) {
            $extensionAttributes = $this->orderExtensionFactory->create();
        }

        $foomanTotalGroup = $extensionAttributes->getFoomanTotalGroup();
        if (!$foomanTotalGroup) {
            $foomanTotalGroup = $this->orderTotalGroupFactory->create();
        }

        $orderTotals = $this->orderTotalManagement->getByOrderId(
            $order->getEntityId()
        );

        if (!empty($orderTotals)) {
            foreach ($orderTotals as $orderTotal) {
                $foomanTotalGroup->addItem($orderTotal);
            }
        }
        $extensionAttributes->setFoomanTotalGroup($foomanTotalGroup);

        $order->setExtensionAttributes($extensionAttributes);
    }
}
