<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Totals\Observer;

use Fooman\Totals\Model\GroupFactory;
use Fooman\Totals\Model\InvoiceTotalManagement;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Sales\Api\Data\InvoiceExtensionFactory;
use Magento\Sales\Api\Data\InvoiceInterface;

class InvoiceLoadAfter implements ObserverInterface
{
    /**
     * @var InvoiceTotalManagement
     */
    private $invoiceTotalManagement;

    /**
     * @var InvoiceExtensionFactory
     */
    private $invoiceExtensionFactory;

    /**
     * @var GroupFactory
     */
    private $invoiceTotalGroupFactory;

    /**
     * @param InvoiceTotalManagement     $invoiceTotalManagement
     * @param InvoiceExtensionFactory $invoiceExtensionFactory
     * @param GroupFactory               $invoiceTotalGroupFactory
     */
    public function __construct(
        InvoiceTotalManagement $invoiceTotalManagement,
        InvoiceExtensionFactory $invoiceExtensionFactory,
        GroupFactory $invoiceTotalGroupFactory
    ) {
        $this->invoiceTotalManagement = $invoiceTotalManagement;
        $this->invoiceExtensionFactory = $invoiceExtensionFactory;
        $this->invoiceTotalGroupFactory = $invoiceTotalGroupFactory;
    }

    /**
     * @param EventObserver $observer
     *
     * @return void
     * @throws \Exception
     */
    public function execute(EventObserver $observer)
    {
        $this->applyExtensionAttributes($observer->getEvent()->getInvoice());
    }

    private function applyExtensionAttributes(InvoiceInterface $invoice)
    {
        $extensionAttributes = $invoice->getExtensionAttributes();
        if (!$extensionAttributes) {
            $extensionAttributes = $this->invoiceExtensionFactory->create();
        }

        $foomanTotalGroup = $extensionAttributes->getFoomanTotalGroup();
        if (!$foomanTotalGroup) {
            $foomanTotalGroup = $this->invoiceTotalGroupFactory->create();
        }

        $invoiceTotals = $this->invoiceTotalManagement->getByInvoiceId(
            $invoice->getEntityId()
        );

        if (!empty($invoiceTotals)) {
            foreach ($invoiceTotals as $invoiceTotal) {
                $foomanTotalGroup->addItem($invoiceTotal);
            }
        }

        $extensionAttributes->setFoomanTotalGroup($foomanTotalGroup);
        $invoice->setExtensionAttributes($extensionAttributes);
    }
}
