<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Totals\Observer;

use Fooman\Totals\Model\CreditmemoTotalManagement;
use Fooman\Totals\Model\GroupFactory;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Sales\Api\Data\CreditmemoExtensionFactory;
use Magento\Sales\Api\Data\CreditmemoInterface;

class CreditmemoLoadAfter implements ObserverInterface
{
    /**
     * @var CreditmemoTotalManagement
     */
    private $creditmemoTotalManagement;

    /**
     * @var CreditmemoExtensionFactory
     */
    private $creditmemoExtensionFactory;

    /**
     * @var GroupFactory
     */
    private $creditmemoTotalGroupFactory;

    /**
     * @param CreditmemoTotalManagement     $creditmemoTotalManagement
     * @param CreditmemoExtensionFactory $creditmemoExtensionFactory
     * @param GroupFactory               $creditmemoTotalGroupFactory
     */
    public function __construct(
        CreditmemoTotalManagement $creditmemoTotalManagement,
        CreditmemoExtensionFactory $creditmemoExtensionFactory,
        GroupFactory $creditmemoTotalGroupFactory
    ) {
        $this->creditmemoTotalManagement = $creditmemoTotalManagement;
        $this->creditmemoExtensionFactory = $creditmemoExtensionFactory;
        $this->creditmemoTotalGroupFactory = $creditmemoTotalGroupFactory;
    }

    /**
     * @param EventObserver $observer
     *
     * @return void
     * @throws \Exception
     */
    public function execute(EventObserver $observer)
    {
        $this->applyExtensionAttributes($observer->getEvent()->getCreditmemo());
    }

    private function applyExtensionAttributes(CreditmemoInterface $creditmemo)
    {
        $extensionAttributes = $creditmemo->getExtensionAttributes();
        if (!$extensionAttributes) {
            $extensionAttributes = $this->creditmemoExtensionFactory->create();
        }

        $foomanTotalGroup = $extensionAttributes->getFoomanTotalGroup();
        if (!$foomanTotalGroup) {
            $foomanTotalGroup = $this->creditmemoTotalGroupFactory->create();
        }

        $creditmemoTotals = $this->creditmemoTotalManagement->getByCreditmemoId(
            $creditmemo->getEntityId()
        );

        if (!empty($creditmemoTotals)) {
            foreach ($creditmemoTotals as $creditmemoTotal) {
                $foomanTotalGroup->addItem($creditmemoTotal);
            }
        }

        $extensionAttributes->setFoomanTotalGroup($foomanTotalGroup);
        $creditmemo->setExtensionAttributes($extensionAttributes);
    }
}
