<?php

namespace Fooman\SurchargeShipping\Plugin;

/**
 * @author     Kristof Ringleff
 * @copyright  Copyright (c) 2017 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
class CancelSurcharge
{

    public function afterSurchargeApplies(
        \Fooman\Surcharge\Model\SurchargeRestrictor $subject,
        $result,
        \Magento\Quote\Api\Data\CartInterface $quote,
        \Fooman\Surcharge\Model\SurchargeConfig $config,
        $total
    ) {
        if (!$result) {
            return $result;
        }
        if ($config->getApplyShippingFilter() != 1) {
            return true;
        }
        $address = $quote->getShippingAddress();
        if (!$address) {
            return false;
        }
        $shippingMethods = $config->getShipping();
        if (!$shippingMethods) {
            return false;
        }

        if (is_string($shippingMethods)) {
            $shippingMethods = [$shippingMethods];
        }
        $currentShippingMethod = $address->getShippingMethod();
        return in_array($currentShippingMethod, $shippingMethods);
    }
}
