<?php
/**
 * @copyright Copyright (c) 2019 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\SurchargeShipping\Block;

use Magento\Framework\Module\ModuleList;
use Magento\Shipping\Model\Config\Source\Allmethods;

class WeightTab extends \Magento\Backend\Block\Widget\Form\Generic
{

    /**
     * @var \Magento\Shipping\Model\Config\Source\Allmethods
     */
    private $shippingMethodsSource;

    /**
     * @var ModuleList
     */
    private $moduleList;

    /**
     * ShippingTab constructor.
     *
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry             $registry
     * @param \Magento\Framework\Data\FormFactory     $formFactory
     * @param Allmethods                              $shippingMethodsSource
     * @param array                                   $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Shipping\Model\Config\Source\Allmethods $shippingMethodsSource,
        ModuleList $moduleList,
        array $data = []
    ) {
        $this->shippingMethodsSource = $shippingMethodsSource;
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Weight Surcharge Settings')]);

        $fieldset->addField(
            'weight',
            'text',
            [
                'label' => __('For every X kg'),
                'title' => __('For every X kg'),
                'name' => 'weight',
                'required' => true,
            ]
        );

        $fieldset->addField(
            'fixed',
            'text',
            [
                'label' => __('Add this Surcharge Amount'),
                'title' => __('Add this Surcharge Amount'),
                'name' => 'fixed',
                'required' => true,
            ]
        );

        if ($this->moduleList->has('Fooman_SurchargeProduct') || $this->moduleList->has('Fooman_ProductFees')) {
            $fieldset->addField(
                'product_default_mode',
                'select',
                [
                    'label' => __('Products'),
                    'title' => __('Products'),
                    'name' => 'product_default_mode',
                    'required' => false,
                    'options' => $this->getModes()
                ]
            );
        }

        $fieldset->addField(
            'max_fixed',
            'text',
            [
                'label' => __('Maximum Surcharge'),
                'title' => __('Maximum Surcharge'),
                'name' => 'max_fixed',
                'required' => false,
            ]
        );

        $fieldset->addField(
            'apply_method_filter',
            'select',
            [
                'label' => __('Apply Shipping Method Filter'),
                'title' => __('Apply Shipping Method Filter'),
                'name' => 'apply_method_filter',
                'required' => false,
                'options' => [
                    0 => __('No'),
                    1 => __('Yes'),
                ]
            ]
        );

        $fieldset->addField(
            'shipping',
            'multiselect',
            [
                'label' => __('Shipping Methods'),
                'title' => __('Shipping Methods'),
                'name' => 'shipping[]',
                'required' => false,
                'values' => $this->getListOfShippingMethods()
            ]
        );

        $fieldset->addField(
            'min',
            'text',
            [
                'label' => __('Order Minimum'),
                'title' => __('Order Minimum'),
                'name' => 'min',
                'required' => false,
            ]
        );

        $fieldset->addField(
            'max',
            'text',
            [
                'label' => __('Order Maximum'),
                'title' => __('Order Maximum'),
                'name' => 'max',
                'required' => false,
            ]
        );

        $registry = $this->_coreRegistry->registry('fooman_surcharge');

        if ($registry) {
            $formData = json_decode($registry->getDataRule(), true);
            $form->addValues($formData);
        }

        $form->setFieldNameSuffix('weight');
        $this->setForm($form);

        return $this;
    }

    public function getModes()
    {
        return [
            'included' => __('are included by default'),
            'excluded' => __('are excluded by default')
        ];
    }

    private function getListOfShippingMethods()
    {
        $isActiveOnlyFlag = false;
        if ($this->moduleList->has('Temando_Shipping')) {
            //If Temando_Shipping is present in 2.2 getting a list of shipping methods causes
            //BadMethodCallException: Missing required argument $offset of Temando\Shipping\Rest\Request\ListRequest.
            //Temando is being shut down 29.10.2019
            $isActiveOnlyFlag = true;
        }
        return $this->shippingMethodsSource->toOptionArray($isActiveOnlyFlag);
    }
}
