<?php
/**
 * @copyright Copyright (c) 2019 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\SurchargeShipping\Block;

use Magento\Framework\Module\ModuleList;
use Magento\Shipping\Model\Config\Source\Allmethods;

class ShippingTab extends \Magento\Backend\Block\Widget\Form\Generic
{

    /**
     * @var \Magento\Shipping\Model\Config\Source\Allmethods
     */
    private $shippingMethodsSource;

    /**
     * @var ModuleList
     */
    private $moduleList;

    /**
     * ShippingTab constructor.
     *
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry             $registry
     * @param \Magento\Framework\Data\FormFactory     $formFactory
     * @param Allmethods                              $shippingMethodsSource
     * @param array                                   $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Shipping\Model\Config\Source\Allmethods $shippingMethodsSource,
        ModuleList $moduleList,
        array $data = []
    ) {
        $this->shippingMethodsSource = $shippingMethodsSource;
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Shipping Surcharge Settings')]);

        $fieldset->addField(
            'shipping',
            'multiselect',
            [
                'label' => __('Shipping Methods'),
                'title' => __('Shipping Methods'),
                'name' => 'shipping[]',
                'required' => true,
                'values' => $this->getListOfShippingMethods()
            ]
        );

        $fieldset->addField(
            'min',
            'text',
            [
                'label' => __('Order Minimum'),
                'title' => __('Order Minimum'),
                'name' => 'min',
                'required' => false,
            ]
        );

        $fieldset->addField(
            'max',
            'text',
            [
                'label' => __('Order Maximum'),
                'title' => __('Order Maximum'),
                'name' => 'max',
                'required' => false,
            ]
        );

        $fieldset->addField(
            'calculation_mode',
            'select',
            [
                'label' => __('Surcharge Calculation Mode'),
                'title' => __('Surcharge Calculation Mode'),
                'name' => 'calculation_mode',
                'required' => true,
                'options' => [
                    \Fooman\Surcharge\Model\SurchargeCalculation::FIXED => __('Fixed'),
                    \Fooman\Surcharge\Model\SurchargeCalculation::PERCENT => __('Percent'),
                    \Fooman\Surcharge\Model\SurchargeCalculation::FIXED_PLUS_PERCENT => __('Fixed + Percent'),
                    \Fooman\Surcharge\Model\SurchargeCalculation::FIXED_MINIMUM => __('Maximum of Fixed or Percent'),
                ]
            ]
        );

        $fieldset->addField(
            'rate',
            'text',
            [
                'label' => __('Surcharge %'),
                'title' => __('Surcharge %'),
                'name' => 'rate',
                'required' => true,
            ]
        );

        $fieldset->addField(
            'fixed',
            'text',
            [
                'label' => __('Surcharge Fixed Cost'),
                'title' => __('Surcharge Fixed Cost'),
                'name' => 'fixed',
                'required' => true,
            ]
        );

        if ($this->_coreRegistry->registry('fooman_surcharge')) {
            $registry = $this->_coreRegistry->registry('fooman_surcharge');
            if ($registry->getDataRule()) {
                $formData = json_decode($registry->getDataRule(), true);
                $form->addValues($formData);
            }
        }

        $form->setFieldNameSuffix('shipping');
        $this->setForm($form);

        return $this;
    }

    private function getListOfShippingMethods()
    {
        $isActiveOnlyFlag = false;
        if ($this->moduleList->has('Temando_Shipping')) {
            //If Temando_Shipping is present in 2.2 getting a list of shipping methods causes
            //BadMethodCallException: Missing required argument $offset of Temando\Shipping\Rest\Request\ListRequest.
            //Temando is being shut down 29.10.2019
            $isActiveOnlyFlag = true;
        }
        return $this->shippingMethodsSource->toOptionArray($isActiveOnlyFlag);
    }
}
