/*
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
define([
    'uiComponent',
    'uiRegistry',
    'Magento_Checkout/js/checkout-data',
    'Fooman_Surcharge/js/set-payment-method',
    'Fooman_SurchargePayment/js/should-refresh-now'
], function (
    Component,
    registry,
    checkoutData,
    setPaymentMethod,
    shouldRefreshNow
) {
    'use strict';

    return Component.extend({
        initialize: function () {
            this._super();
        },
        executeDelayedRefreshIfNeeded: function () {
            var paymentMethodSubmit = registry.get('fooman_delayed_refresh_needed');
            if (paymentMethodSubmit !== false && shouldRefreshNow(checkoutData)) {
                registry.set('fooman_delayed_refresh_needed', false);
                setPaymentMethod(paymentMethodSubmit);
            }
        }
    });
});
