/*
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
define([
    'uiComponent',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Fooman_SurchargePayment/js/should-refresh',
    'Fooman_SurchargePayment/js/should-refresh-now',
    'Fooman_Surcharge/js/set-payment-method',
    'uiRegistry'
], function (
    Component,
    quote,
    checkoutData,
    shouldRefresh,
    shouldRefreshNow,
    setPaymentMethod,
    registry
) {
    'use strict';

    registry.set('fooman_delayed_refresh_needed', false);

    return Component.extend({
        initialize: function () {
            this._super();

            quote.paymentMethod.subscribe(function (newValue) {
                if (shouldRefresh(checkoutData, newValue)) {
                    if (shouldRefreshNow(checkoutData)) {
                        registry.set('fooman_delayed_refresh_needed', false);
                        setPaymentMethod(newValue.method);
                    } else {
                        registry.set('fooman_delayed_refresh_needed', newValue.method);
                    }
                }
            }, this);
        }
    });
});
