<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\SurchargePayment\Model;

use Fooman\Surcharge\Model\ResourceModel\Surcharge\CollectionFactory;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\Module\Dir;
use Magento\Framework\Module\Dir\Reader;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;

class SurchargeConfigProvider implements ConfigProviderInterface
{

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var File
     */
    private $file;

    /**
     * @var Reader
     */
    private $moduleReader;

    public function __construct(
        CollectionFactory $collectionFactory,
        StoreManagerInterface $storeManager,
        File $file,
        Reader $moduleReader
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->storeManager = $storeManager;
        $this->file = $file;
        $this->moduleReader = $moduleReader;
    }

    public function getConfig()
    {
        return [
            'foomanPaymentSurchargeConfig' => [
                'requiresPaymentRefresh' => $this->requiresPaymentRefresh()
            ]
        ];
    }

    /**
     * If this mixin exists Magento is already refreshing the payment method upon change
     * no need for us to repeat (does not yet work as Magento Core does not submit all relevant data)
     *
     * @return bool
     */
    private function isPaymentRefreshedByMagentoCore()
    {
        $salesRuleDir = $this->moduleReader->getModuleDir(
            Dir::MODULE_VIEW_DIR,
            'Magento_SalesRule'
        );
        try {
            return $this->file->isExists($salesRuleDir.'/frontend/web/js/action/select-payment-method-mixin.js');
        } catch (\Exception $e) {
            return true;
        }
    }

    /**
     * @return int
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function requiresPaymentRefresh()
    {
        try {
            $collection = $this->getSurcharges();
            return $collection->getSize() == 0 ? 0 : 1;
        } catch (\Exception $e) {
            return 0;
        }
    }

    /**
     * @return \Fooman\Surcharge\Model\ResourceModel\Surcharge\Collection
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    private function getSurcharges()
    {
        $currentStoreId = $this->storeManager->getStore()->getId();
        $collection = $this->collectionFactory->create();
        $collection
            ->addFieldToFilter('store_id', [$currentStoreId, Store::DEFAULT_STORE_ID])
            ->addFieldToFilter('type', 'payment')
            ->addFieldToFilter('is_active', true);
        return $collection;
    }
}
