<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\SurchargeMinimumAmount\Model;

class MinimumAmountType implements \Fooman\Surcharge\Api\Data\TypeInterface
{
    /**
     * @var string
     */
    private $type = 'minimum_amount';

    /**
     * @var \Fooman\Surcharge\Helper\SurchargeConfig
     */
    private $surchargeConfigHelper;

    /**
     * @var \Fooman\Surcharge\Model\SurchargeCalculationFactory
     */
    private $surchargeCalculationFactory;

    /**
     * @var \Fooman\Totals\Model\QuoteAddressTotalManagement
     */
    private $quoteAddressManagement;

    /**
     * @param \Fooman\Surcharge\Model\SurchargeCalculationFactory $surchargeCalculationFactory
     * @param \Fooman\Surcharge\Helper\SurchargeConfig            $surchargeConfigHelper
     * @param \Fooman\Totals\Model\QuoteAddressTotalManagement    $quoteAddressTotalManagement
     */
    public function __construct(
        \Fooman\Surcharge\Model\SurchargeCalculationFactory $surchargeCalculationFactory,
        \Fooman\Surcharge\Helper\SurchargeConfig $surchargeConfigHelper,
        \Fooman\Totals\Model\QuoteAddressTotalManagement $quoteAddressTotalManagement
    ) {
        $this->surchargeCalculationFactory = $surchargeCalculationFactory;
        $this->surchargeConfigHelper = $surchargeConfigHelper;
        $this->quoteAddressManagement = $quoteAddressTotalManagement;
    }

    /**
     * @param  \Fooman\Surcharge\Api\SurchargeInterface $surcharge
     * @param  \Magento\Quote\Api\Data\CartInterface    $quote
     *
     * @return \Fooman\Totals\Api\Data\QuoteAddressTotalInterface[]
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function calculate(
        \Fooman\Surcharge\Api\SurchargeInterface $surcharge,
        \Magento\Quote\Api\Data\CartInterface $quote,
        \Magento\Quote\Api\Data\ShippingAssignmentInterface $shippingAssignment
    ) {
        $config = $this->surchargeConfigHelper->getConfig($surcharge);
        $surchargeCalculation = $this->surchargeCalculationFactory
            ->create(['quote' => $quote, 'surcharge' => $surcharge, 'assignment' => $shippingAssignment]);

        $currentSubTotal = $surchargeCalculation->getCurrentSubTotal();

        if ($currentSubTotal < $this->getMinimumAmount($config, $quote)) {
            $total = $surchargeCalculation->processTotals();
            $total->setLabel($surcharge->getDescription());
            return [$total];
        }

        $this->quoteAddressManagement->deleteByTypeIdAndQuoteId($surcharge->getTypeId(), $quote->getId());
        return [];
    }

    public function getMinimumAmount($config, $quote)
    {
        return $config->getMinimumAmount();
    }

    /**
     * @return \Magento\Framework\Phrase
     */
    public function getLabel()
    {
        return __('Small Order Fee');
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
}
