<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\SurchargeMinimumAmount\Block;

use Fooman\Surcharge\Model\SurchargeCalculation;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Framework\Data\Form;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Module\ModuleList;
use Magento\Framework\Registry;

class MinimumAmountTab extends Generic
{

    /**
     * @var ModuleList
     */
    private $moduleList;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        ModuleList $moduleList,
        array $data = []
    ) {
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        /** @var Form $form */
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Small Order Fee Settings')]);

        $fieldset->addField('minimum_amount', 'text', [
            'label' => __('Minimum Amount'),
            'title' => __('Minimum Amount'),
            'name' => 'minimum_amount',
            'required' => true,
        ]);

        if ($this->moduleList->has('Fooman_ProductFees')) {
            $fieldset->addField(
                'product_default_mode',
                'select',
                [
                    'label' => __('Products'),
                    'title' => __('Products'),
                    'name' => 'product_default_mode',
                    'required' => false,
                    'options' => $this->getModes()
                ]
            );
        }

        $fieldset->addField('min', 'text', [
            'label' => __('Order Minimum'),
            'title' => __('Order Minimum'),
            'name' => 'min',
            'required' => false,
        ]);

        $fieldset->addField('max', 'text', [
            'label' => __('Order Maximum'),
            'title' => __('Order Maximum'),
            'name' => 'max',
            'required' => false,
        ]);

        $calculationModeField = $fieldset->addField('calculation_mode', 'select', [
            'label' => __('Surcharge Calculation Mode'),
            'title' => __('Surcharge Calculation Mode'),
            'name' => 'calculation_mode',
            'required' => true,
            'options' => [
                SurchargeCalculation::FIXED => __('Fixed'),
                SurchargeCalculation::PERCENT => __('Percent'),
                SurchargeCalculation::FIXED_PLUS_PERCENT => __('Fixed + Percent'),
                SurchargeCalculation::FIXED_MINIMUM => __('Maximum of Fixed or Percent'),
            ]
        ]);

        $calculationModeField->setAfterElementHtml(
            "
<script>
require([
    'prototype'
], function(prototype) {

$('rate').hide();
$('fixed').hide();
$('rate').up(1).select('label').first().hide();            
$('fixed').up(1).select('label').first().hide();

function toggleFields() {
    var currentValue = $('calculation_mode').getValue();    
    switch(currentValue) {
        case '" . SurchargeCalculation::FIXED . "':
            $('rate').hide();
            $('rate').up(1).select('label').first().hide();
            $('fixed').show();
            $('fixed').up(1).select('label').first().show();
            break;
        case '" . SurchargeCalculation::PERCENT . "':
            $('rate').show();
            $('rate').up(1).select('label').first().show();
            $('fixed').hide();
            $('fixed').up(1).select('label').first().hide();
            break;
        case '" . SurchargeCalculation::FIXED_PLUS_PERCENT . "':
            $('rate').show();
            $('rate').up(1).select('label').first().show();
            $('fixed').show();
            $('fixed').up(1).select('label').first().show();
            break;
        case '" . SurchargeCalculation::FIXED_MINIMUM . "':
            $('rate').show();
            $('rate').up(1).select('label').first().show();
            $('fixed').show();
            $('fixed').up(1).select('label').first().show();
    }
}

$('calculation_mode').observe('change', toggleFields);
toggleFields();

});
</script>"
        );

        $fieldset->addField('rate', 'text', [
            'label' => __('Surcharge %'),
            'title' => __('Surcharge %'),
            'name' => 'rate',
            'required' => false,
        ]);

        $fieldset->addField('fixed', 'text', [
            'label' => __('Surcharge Fixed Cost'),
            'title' => __('Surcharge Fixed Cost'),
            'name' => 'fixed',
            'required' => false,
        ]);

        if ($this->_coreRegistry->registry('fooman_surcharge')) {
            $registry = $this->_coreRegistry->registry('fooman_surcharge');
            if ($registry->getDataRule()) {
                $formData = json_decode($registry->getDataRule(), true);
                $form->addValues($formData);
            }
        }

        $form->setFieldNameSuffix('minimum_amount');
        $this->setForm($form);
        return $this;
    }

    public function getModes()
    {
        return [
            'included' => __('are included by default'),
            'excluded' => __('are excluded by default')
        ];
    }
}
