<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\SurchargeMinimumAmount\Block;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Framework\Data\Form;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Module\ModuleList;
use Magento\Framework\Registry;

class EnforcedAmountTab extends Generic
{
    /**
     * @var ModuleList
     */
    private $moduleList;

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        ModuleList $moduleList,
        array $data = []
    ) {
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        /** @var Form $form */
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Minimum Order Fee Settings')]);

        $fieldset->addField('enforced_amount', 'text', [
            'label' => __('Minimum Amount'),
            'title' => __('Minimum Amount'),
            'name' => 'enforced_amount',
            'required' => true,
        ]);

        $fieldset->addField('min', 'text', [
            'label' => __('Order Minimum'),
            'title' => __('Order Minimum'),
            'name' => 'min',
            'required' => false,
        ]);

        $fieldset->addField('max', 'text', [
            'label' => __('Order Maximum'),
            'title' => __('Order Maximum'),
            'name' => 'max',
            'required' => false,
        ]);

        if ($this->moduleList->has('Fooman_ProductFees')) {
            $fieldset->addField(
                'product_default_mode',
                'select',
                [
                    'label' => __('Products'),
                    'title' => __('Products'),
                    'name' => 'product_default_mode',
                    'required' => false,
                    'options' => $this->getModes()
                ]
            );
        }

        if ($this->_coreRegistry->registry('fooman_surcharge')) {
            $registry = $this->_coreRegistry->registry('fooman_surcharge');
            if ($registry->getDataRule()) {
                $formData = json_decode($registry->getDataRule(), true);
                $form->addValues($formData);
            }
        }

        $form->setFieldNameSuffix('enforced_amount');
        $this->setForm($form);
        return $this;
    }

    public function getModes()
    {
        return [
            'included' => __('are included by default'),
            'excluded' => __('are excluded by default')
        ];
    }
}
