/*
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
define([
    'uiComponent',
    'Magento_Checkout/js/action/set-payment-information',
    'Magento_Checkout/js/view/payment/default',
    'Magento_Checkout/js/action/get-totals',
    'jquery',
    'underscore',
    'ko'
], function (
    Component,
    setPaymentInformation,
    defaultPayment,
    getTotals,
    $,
    _,
    ko
) {
    'use strict';

    return _.debounce(function (paymentMethod) {
        if ($('#'+paymentMethod).length ) {
            var paymentMethodUI = ko.dataFor($('#' + paymentMethod)[0]);
            var paymentMethodSubmit = paymentMethodUI.getData();
        } else {
            var paymentMethodSubmit = {
                method: paymentMethod,
                additional_data: {}
            };
        }

        paymentMethodSubmit.additional_data = $.extend(
            true,
            paymentMethodSubmit.additional_data,
            {
                'fooman_payment_surcharge_preview': "true",
                'buckaroo_skip_validation': "true"
            }
        );
        $.when(setPaymentInformation(defaultPayment.messageContainer, paymentMethodSubmit))
            .done(function () {
                getTotals([], false);
            });
    }, 100);
});
