/*
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
define([
    'uiComponent',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/view/payment/default',
    'Magento_Checkout/js/checkout-data',
    'Fooman_Surcharge/js/should-refresh',
    'Fooman_Surcharge/js/set-payment-method',
    'jquery'
], function (
    Component,
    quote,
    defaultPayment,
    checkoutData,
    shouldRefresh,
    setPaymentMethod,
    $
) {
    'use strict';
    return Component.extend({
        initialize: function () {
            this._super();
            if (window.checkoutConfig.foomanSurchargeConfig.active
                && window.checkoutConfig.foomanSurchargeConfig.requiresBillingRefresh) {
                quote.billingAddress.subscribe(function (newValue) {
                    if (quote.getPaymentMethod()()
                        && quote.getPaymentMethod()().method
                        && $('#'+quote.getPaymentMethod()().method).length
                        && shouldRefresh(checkoutData, newValue)
                    ) {
                        setPaymentMethod(quote.getPaymentMethod()().method);
                    }
                }, this);
            }
        }
    });
});
