<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Ui\Component\Listing\Column;

use Fooman\Surcharge\Model\Config;
use Magento\Framework\Data\OptionSourceInterface;

class TypeSelectOptions implements OptionSourceInterface
{

    /**
     * @var Config
     */
    private $config;

    public function __construct(
        Config $config
    ) {
        $this->config = $config;
    }

    public function toOptionArray()
    {
        $options[] = [
            'label' => __('All'),
            'value'=> ''
        ];
        if ($this->config->getTypes()) {
            foreach ($this->config->getTypes() as $type) {
                $options[] = [
                    'label' => __($type['label']),
                    'value'=> $type['type']
                ];
            }
        }
        return $options;
    }
}
