<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\App\ResourceConnection;
use Fooman\Surcharge\Model\ResourceModel\Surcharge\CollectionFactory as SurchargeCollectionFactory;
use Fooman\Surcharge\Helper\Currency as CurrencyHelper;

class TotalAmountCollected extends \Magento\Ui\Component\Listing\Columns\Column
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var SurchargeCollectionFactory
     */
    private $surchargeCollectionFactory;

    /**
     * @var CurrencyHelper
     */
    private $currencyHelper;

    /**
     * @param ContextInterface              $context
     * @param UiComponentFactory            $uiComponentFactory
     * @param ResourceConnection            $resourceConnection
     * @param SurchargeCollectionFactory    $surchargeCollectionFactory
     * @param CurrencyHelper                $currencyHelper
     * @param array                         $components
     * @param array                         $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        ResourceConnection $resourceConnection,
        SurchargeCollectionFactory $surchargeCollectionFactory,
        CurrencyHelper $currencyHelper,
        array $components = [],
        array $data = []
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->surchargeCollectionFactory = $surchargeCollectionFactory;
        $this->currencyHelper = $currencyHelper;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        $surchargeCollection = $this->surchargeCollectionFactory->create();
        $connection = $this->resourceConnection->getConnection();
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $surcharge = $surchargeCollection->addFieldToFilter('id', $item['id'])->getFirstItem();
                $typeId = $surcharge->getTypeId();

                $invoiceQuery = $connection->select()
                    ->from(
                        [
                            'fooman_totals_invoice'=>
                                $this->resourceConnection->getTableName('fooman_totals_invoice')
                        ],
                        new \Zend_Db_Expr('SUM(fooman_totals_invoice.base_amount)')
                    )
                    ->where('fooman_totals_invoice.type_id = ?', $typeId);

                $baseAmountInvoiced = isset($connection->fetchCol($invoiceQuery)[0])
                    ? $connection->fetchCol($invoiceQuery)[0]
                    : '0';

                $creditmemoQuery = $connection->select()
                    ->from(
                        [
                            'fooman_totals_creditmemo' =>
                                $this->resourceConnection->getTableName('fooman_totals_creditmemo')
                        ],
                        new \Zend_Db_Expr('SUM(fooman_totals_creditmemo.base_amount)')
                    )
                    ->where('fooman_totals_creditmemo.type_id = ?', $typeId);

                $baseAmountRefunded = isset($connection->fetchCol($creditmemoQuery)[0])
                    ? $connection->fetchCol($creditmemoQuery)[0]
                    : '0';

                $item[$this->getData('name')] =
                    $this->currencyHelper->format($baseAmountInvoiced - $baseAmountRefunded);
                $surchargeCollection->clear()->getSelect()->reset('where');
            }
        }

        return $dataSource;
    }
}
