<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Plugin;

use Magento\Sales\Api\Data\CreditmemoCommentCreationInterface;
use Magento\Sales\Api\Data\CreditmemoCreationArgumentsInterface;
use Magento\Sales\Api\Data\CreditmemoInterface;
use Magento\Sales\Api\Data\InvoiceInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\Order\CreditmemoDocumentFactory;

class CreditmemoFactory
{
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    public function __construct(
        \Magento\Framework\App\RequestInterface $request
    ) {
        $this->request = $request;
    }

    /**
     * @param CreditmemoDocumentFactory $subject
     * @param OrderInterface $order
     * @param array $items
     * @param CreditmemoCommentCreationInterface|null $comment
     * @param $appendComment
     * @param CreditmemoCreationArgumentsInterface|null $arguments
     * @return array
     */
    public function beforeCreateFromOrder(
        CreditmemoDocumentFactory $subject,
        OrderInterface $order,
        array $items = [],
        CreditmemoCommentCreationInterface $comment = null,
        $appendComment = false,
        CreditmemoCreationArgumentsInterface $arguments = null
    ) {
        if ($arguments !== null
            && $arguments->getExtensionAttributes() !== null
            && $arguments->getExtensionAttributes()->getFoomanSurchargeAmounts() !== null
        ) {
            $surcharges = $arguments->getExtensionAttributes()->getFoomanSurchargeAmounts();
            $params = $this->request->getParams();
            foreach ($surcharges as $surcharge) {
                $params['creditmemo']['fooman_surcharge'][$surcharge->getTypeId()] = $surcharge->getTaxInclAmount();
            }
            $this->request->setParams($params);
        }
        return [$order, $items, $comment, $appendComment, $arguments];
    }

    /**
     * @param CreditmemoDocumentFactory $subject
     * @param InvoiceInterface $invoice
     * @param array $items
     * @param CreditmemoCommentCreationInterface|null $comment
     * @param $appendComment
     * @param CreditmemoCreationArgumentsInterface|null $arguments
     * @return array
     */
    public function beforeCreateFromInvoice(
        CreditmemoDocumentFactory $subject,
        InvoiceInterface $invoice,
        array $items = [],
        CreditmemoCommentCreationInterface $comment = null,
        $appendComment = false,
        CreditmemoCreationArgumentsInterface $arguments = null
    ) {
        if ($arguments !== null
            && $arguments->getExtensionAttributes() !== null
            && $arguments->getExtensionAttributes()->getFoomanSurchargeAmounts() !== null
        ) {
            $surcharges = $arguments->getExtensionAttributes()->getFoomanSurchargeAmounts();
            $params = $this->request->getParams();
            foreach ($surcharges as $surcharge) {
                $params['creditmemo']['fooman_surcharge'][$surcharge->getTypeId()] = $surcharge->getTaxInclAmount();
            }
            $this->request->setParams($params);
        }
        return [$invoice, $items, $comment, $appendComment, $arguments];
    }
}
