<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Plugin;

class Creditmemo
{

    private $orderTotalManagement;

    public function __construct(
        \Fooman\Totals\Model\OrderTotalManagement $orderTotalManagement
    ) {
        $this->orderTotalManagement = $orderTotalManagement;
    }

    /**
     * Magento's creditmemos overstate tax, their calculation automatically takes up all existing tax
     * irrespective of origin. Forcing isLast triggers the code pathway that calculates tax from items
     */
    public function afterIsLast(
        \Magento\Sales\Model\Order\Creditmemo $creditmemo,
        $result
    ) {
        $creditmemo->setFoomanOrigIsLastResult($result);
        if (!$creditmemo->getFoomanRequiresTaxFix()) {
            return $result;
        }
        if ($this->hasSurcharge($creditmemo->getOrder()->getEntityId())) {
            return false;
        }
        return $result;
    }

    private function hasSurcharge($orderId)
    {
        $surcharges = $this->orderTotalManagement->getByOrderId($orderId);
        return count($surcharges) > 0;
    }
}
