<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Plugin\Adminhtml;

use Fooman\Surcharge\Model\SurchargeCalculation;

class OverrideAmounts
{
    private $request;

    public function __construct(
        \Magento\Framework\App\RequestInterface $request
    ) {
        $this->request = $request;
    }

    public function aroundProcessTotals(
        SurchargeCalculation $subject,
        \Closure $proceed,
        $reset = false,
        $amount = null,
        $adjustTax = false
    ) {

        $surcharge = $subject->getSurcharge();
        $params = $this->request->getParam('order');
        if (isset($params['fooman_surcharge'][$surcharge->getTypeId()])) {
            $quoteAmount = $params['fooman_surcharge'][$surcharge->getTypeId()];
            if ($quoteAmount) {
                $quoteAmount = str_replace(',', '.', $quoteAmount);
                $quoteAmount = preg_replace('/[^\d\-\.]+/', '', $quoteAmount);
            }
            return $subject->processAdminTotal($quoteAmount);
        }

        return $proceed($reset, $amount, $adjustTax);
    }
}
