<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Model;

class Surcharge extends \Magento\Framework\Model\AbstractModel implements \Fooman\Surcharge\Api\SurchargeInterface
{
    const CODE = 'fooman_surcharge';

    /**
     * @var \Fooman\Surcharge\Model\TypeFactory
     */
    private $typeFactory;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Fooman\Surcharge\Model\TypeFactory $typeFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->typeFactory = $typeFactory;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    //phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore -- Magento Core Use
    protected function _construct()
    {
        $this->_init(\Fooman\Surcharge\Model\ResourceModel\Surcharge::class);
    }

    /**
     * @param \Magento\Quote\Api\Data\CartInterface $quote
     * @param \Magento\Quote\Api\Data\ShippingAssignmentInterface $shippingAssignment
     * @return \Fooman\Totals\Api\Data\QuoteAddressTotalInterface[]|\Fooman\Totals\Model\QuoteAddressTotal[]
     */
    public function collect(
        \Magento\Quote\Api\Data\CartInterface $quote,
        \Magento\Quote\Api\Data\ShippingAssignmentInterface $shippingAssignment
    ) {
        $typeInstance = $this->getTypeInstance();
        if (null === $typeInstance) {
            return [];
        }
        return $this->getTypeInstance()->calculate($this, $quote, $shippingAssignment);
    }

    public function getTypeInstance()
    {
        return $this->typeFactory->get($this->getType());
    }

    public function getTypeId()
    {
        return $this->getType() . $this->getId();
    }

    public function getType()
    {
        return $this->getData('type');
    }

    public function getId()
    {
        return $this->getData('id');
    }

    public function getDescription()
    {
        return $this->getData('description');
    }
}
