<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Helper;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Pricing\PriceCurrencyInterface;
use Magento\Quote\Api\Data\CartInterface;

class Currency
{

    /**
     * @var PriceCurrencyInterface
     */
    private $priceCurrency;

    /**
     * @param PriceCurrencyInterface $priceCurrency
     */
    public function __construct(
        PriceCurrencyInterface $priceCurrency
    ) {
        $this->priceCurrency = $priceCurrency;
    }

    /**
     * @param  CartInterface $quote
     * @param  float $baseAmount
     *
     * @return float
     */
    public function convertToQuoteCurrency(
        CartInterface $quote,
        $baseAmount
    ) {
        return $this->priceCurrency->convertAndRound(
            $baseAmount,
            $quote->getStore(),
            $quote->getCurrency()
        );
    }

    /**
     * @param CartInterface $quote
     * @param $amount
     * @return float
     * @throws LocalizedException
     */
    public function convertToBaseCurrency(
        CartInterface $quote,
        $amount
    ) {
        $baseCurrency = $this->priceCurrency->getCurrency(
            $quote->getStoreId(),
            $quote->getBaseCurrencyCode()
        );

        $rate = $baseCurrency->getRate($quote->getQuoteCurrencyCode());
        if (!$rate) {
            throw new LocalizedException(__(
                'Undefined rate from "%1-%2".',
                $quote->getBaseCurrencyCode(),
                $quote->getQuoteCurrencyCode()
            ));
        }
        return $this->priceCurrency->round($amount/$rate);
    }

    public function round($amount)
    {
        return $this->priceCurrency->round($amount);
    }

    public function format($amount)
    {
        return $this->priceCurrency->format($amount);
    }

    public function formatWithContainer($amount, $includeContainer = true)
    {
        return $this->priceCurrency->format($amount, $includeContainer);
    }
}
