<?php
/**
 * @copyright Copyright (c) 2016 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\Surcharge\Controller\Adminhtml\Manage;

class Index extends \Magento\Backend\App\Action
{
    const ADMIN_RESOURCE = 'Fooman_Surcharge::surcharge';

    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    private $coreRegistry;

    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private $resultPageFactory;

    /**
     * @var \Fooman\Surcharge\Model\ResourceModel\Surcharge\Collection
     */
    private $collection;

    /**
     * @param \Magento\Backend\App\Action\Context        $context
     * @param \Magento\Framework\Registry                $coreRegistry
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Fooman\Surcharge\Model\ResourceModel\Surcharge\Collection $collection
    ) {
        $this->coreRegistry = $coreRegistry;
        $this->resultPageFactory = $resultPageFactory;
        $this->collection = $collection;
        parent::__construct($context);
    }

    /**
     * Index action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Fees & Surcharges'));
        return $resultPage;
    }

    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Fooman_Surcharge::surcharge')
            ->addBreadcrumb(__('Sales'), __('Sales'))
            ->addBreadcrumb(__('Fees & Surcharges'), __('Fees & Surcharges'));
        return $resultPage;
    }
}
