<?php
namespace Fooman\Surcharge\Block\Adminhtml\OrderCreate;

use Magento\Framework\Pricing\PriceCurrencyInterface;
use Fooman\Surcharge\Helper\Surcharge as SurchargeHelper;

class Surcharge extends \Magento\Sales\Block\Adminhtml\Order\Create\Totals\DefaultTotals
{
    // phpcs:ignore PSR2.Classes.PropertyDeclaration.Underscore -- Magento 2 core use
    protected $_template = 'Fooman_Surcharge::orderCreate/totals/surcharge.phtml';

    private $surchargeHelper;
    private $loadedSurcharges = [];

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Model\Session\Quote $sessionQuote,
        \Magento\Sales\Model\AdminOrder\Create $orderCreate,
        PriceCurrencyInterface $priceCurrency,
        \Magento\Sales\Helper\Data $salesData,
        \Magento\Sales\Model\Config $salesConfig,
        SurchargeHelper $surchargeHelper,
        array $data = []
    ) {
        $this->surchargeHelper = $surchargeHelper;
        parent::__construct(
            $context,
            $sessionQuote,
            $orderCreate,
            $priceCurrency,
            $salesData,
            $salesConfig,
            $data
        );
    }

    public function getAmountToDisplay($surcharge)
    {
        if ($this->isSurchargeTaxInclusive($surcharge)) {
            return $surcharge->getAmount() + $surcharge->getTaxAmount();
        }
        return $surcharge->getAmount();
    }

    public function getLabel($surcharge)
    {
        if ($this->isSurchargeTaxInclusive($surcharge)) {
            return $surcharge->getLabel(). ' (' . __('Incl. Tax').')';
        }
        return $surcharge->getLabel(). ' (' . __('Excl. Tax').')';
    }

    private function getLoadedSurcharge($surcharge)
    {
        $typeId = $surcharge->getTypeId();
        if (!isset($this->loadedSurcharges[$typeId])) {
            $this->loadedSurcharges[$typeId] = $this->surchargeHelper->getSurchargeByTypeId($typeId);
        }
        return $this->loadedSurcharges[$typeId];
    }

    private function isSurchargeTaxInclusive($surcharge)
    {
        $surchargeObject = $this->getLoadedSurcharge($surcharge);
        $taxInclusive = (int)$surchargeObject->getTaxInclusive();
        return ($surchargeObject->getTaxClassId() && ($taxInclusive === 1 || $taxInclusive === 2));
    }
}
