# Change Log

## [14.1.1] - 2023-03-28
### Added
- Ability to set surcharge amounts in REST request body

## [14.1.0] - 2023-02-09
### Added
- Support for Php 8.2

## [14.0.2] - 2023-01-26
### Fixed
- Prevent errors when quote collection happens without a type instance

## [14.0.1] - 2023-01-24
### Fixed
- Grid ID sorting

## [14.0.0] - 2022-11-25
### Added
- Hyvä Support - ensure surcharges are displayed on cart page 
### Fixed
- Allow label to be translated
- Admin input for surcharges now follows tax setting of the surcharge
### Changed
- Fallback to default customer addresses when no address has been selected for quote yet
  Constructor change in Model\SurchargeRestrictor

## [13.0.5] - 2022-08-09
## Fixed
- Editing Admin orders with tax inclusive surcharge amounts

## [13.0.4] - 2022-08-05
### Fixed
- Creditmemo fix from 13.0.3 should only fallback if no extension attributes were loaded

## [13.0.3] - 2022-07-01
### Fixed
- Creditmemos for negative surcharges
- Adjustment of creditmemo taxrate detailed display if not loaded via repository

## [13.0.2] - 2022-04-04
### Fixed
- Admin entered amounts did not factor out tax component correctly

## [13.0.1] - 2022-03-12
### Fixed
- Surcharge tab in admin fix

## [13.0.0] - 2022-03-02
### Changed
- Minimum supported Magento version is now 2.3.0 - for earlier versions please use previous releases
- Converted to use db_schema.xml

## [12.4.2] - 2022-01-31
### Fixed
- Conversion rate for manual admin surcharges when not using the base currency

## [12.4.1] - 2022-01-30
### Fixed
- Min/Max values can also be empty strings

## [12.4.0] - 2022-01-29
### Added
- Ability to provide an explanation to the surcharge either as a separate line or tooltip
- Support for Php 8.0 and 8.1

## [12.3.1] - 2022-01-19
## Fixed
- Reinstate missing surcharge tax on creditmemos

## [12.3.0] - 2022-01-18
## Fixed
- Creditmemo tax calculations for partial refunds
- Subtotal inclusive tax display for zero item creditmemos

## [12.2.1] - 2021-11-05
### Changed
- Heading changed to Fees & Surcharges
### Fixed
- Allow admin entered amounts with comma

## [12.2.0] - 2021-11-05
### Added
- Ability to override surcharge amounts in admin orders
- Surcharges can factor in other surcharges into calculation
- Tax inclusive mode that reduces by store tax

## [12.1.0] - 2021-10-25
### Added
- Flag for processing totals to run tax inclusive adjustments

## [12.0.5] - 2021-09-17
## Fixed
- Total Collected with database table prefix

## [12.0.4] - 2021-09-16
## Fixed
- Allow comma adjustment to work with multi-select values

## [12.0.3] - 2021-09-16
### Fixed
- Automatically adjust values entered with comma

## [12.0.2] - 2021-05-06
### Fixed
- In manual amount setting mode we do not want to run tax adjustments

## [12.0.1] - 2021-05-06
### Fixed
- Combine payment refreshes in Surcharge Core, throttle number of update requests

## [12.0.0] - 2021-04-30
### Fixed
- Only use billing refresh if an active surcharge requires it
  Constructor change in Model\SurchargeConfigProvider

## [11.6.0] - 2021-04-06
### Added
- Ability to directly supply a surcharge total amount for calculation

## [11.5.0] - 2021-03-22
### Added
- Display Total Collected for each Surcharge Type
### Fixed
- Double counting of dynamic price bundle items towards subtotal
- Load our JS on Magestore Checkout

## [11.4.1] - 2021-01-02
### Fixed
- Wait with billing address update until information is available

## [11.4.0] - 2021-01-02
### Added
- Restrict Surcharges by Region

## [11.3.1] - 2020-11-11
### Fixed
- Knockout number handling

## [11.3.0] - 2020-07-29
### Added
- Support for Magento 2.4.0
- Support for Php 7.4

## [11.2.1] - 2020-04-02
### Fixed
- Use Base currency for Paypal transactions

## [11.2.0] - 2020-02-27
### Added
- Set Surcharge ID on Config Object

## [11.1.2] - 2019-12-11
### Fixed
- Magento can't handle negative tax amounts when tax is applied after discount

## [11.1.1] - 2019-11-20
### Fixed
- Some Magento versions miss surcharge taxes on invoices with configurable products

## [11.1.0] - 2019-10-17
### Added
- Extension point to exclude products from subtotal calculations

## [11.0.5] - 2019-10-07
### Changed
- Split quote addresses in integration tests

## [11.0.4] - 2019-09-24
### Fixed
- Preview surcharges in cart without the need to select a shipping method

## [11.0.3] - 2019-09-24
### Fixed
- Add brackets to total amounts on sales totals to align with Magento Core display

## [11.0.2] - 2019-09-24
### Fixed
- Add brackets to total amounts on pdf totals to align with Magento Core display

## [11.0.1] - 2019-09-24
### Fixed
- Pass Surcharge base amounts to pdf totals

## [11.0.0] - 2019-09-20
### Changed
- Added parameter to Api\Data\TypeInterface::calculate() and Api\SurchargeInterface::collect()
### Added
- Surcharge calculation for multi-address checkouts
### Fixed
- Remove superfluous layout instruction

## [10.0.2] - 2019-09-13
### Changed
- Implemented latest Magento Coding Standard
### Fixed
- Surcharge on Cart page now follows sort order
- Populate in process surcharge tax amounts for cart page display

## [10.0.1] - 2019-03-08
### Fixed
- Changelog formatting

## [10.0.0] - 2019-03-08
### Added
- Ability to define surcharges tax inclusively
Constructor change on Model\SurchargeCalculation
and Model\Total\Quote\Surcharge\AfterTaxCalc

## [9.0.0] - 2018-12-14
### Added
- Ability to restrict surcharges by country/region
Constructor change on Block\Adminhtml\Surcharge\Edit\Tab\General

## [8.0.4] - 2018-12-02
### Fixed
- Ensure invoice total collection works for empty fooman totals 

## [8.0.3] - 2018-11-30
### Added
- Support for Magento 2.3

## [8.0.2] - 2018-11-09
### Fixed
- Zeroing out Surcharge on Creditmemo should not remove input box

## [8.0.1] - 2018-11-08
### Fixed
- Consider Tax Compensation amount when using tax inclusive discounts

## [8.0.0] - 2018-11-07
### Changed
- Adjusted loading and handling of extension attributes on quote addresses
Constructor change on Model\Total\Quote\Surcharge

## [7.1.2] - 2018-10-24
### Fixed
- Don't use identifiers with Paypal carts as Magento default merges them to all items

## [7.1.1] - 2018-10-23
### Fixed
- Display Surcharges on Sales Order Print View
### Changed
- Don't combine surcharges when sending Paypal cart contents

## [7.1.0] - 2018-10-03
### Added
- Support for negative surcharges
### Fixed
- We might not yet have a persisted order object when the invoice totals are calculated

## [7.0.8] - 2018-07-23
### Changed
- Reorganise unit tests

## [7.0.7] - 2018-07-02
### Fixed
- Remove surcharges from other store views when switching stores in a multi-store environment

## [7.0.6] - 2018-06-15
### Fixed
- Reset database total earlier

## [7.0.5] - 2018-05-14
### Fixed
- Avoid using subtotal with discounts as older versions of Magento incorrectly update it

## [7.0.4] - 2018-05-05
### Fixed
- Ensure extension attributes are set on TotalsSegment
- Pull in latest Fooman Totals fix for extension attributes array conversion

## [7.0.3] - 2018-04-19
### Changed
- Use php ::class constants when referencing classes
### Fixed
- Pull in latest Fooman Totals fix for extension attributes can sometimes be an array

## [7.0.2] - 2018-04-05
### Fixed
- During invoice/creditmemo calculation only use DB data

## [7.0.1] - 2018-04-04
### Fixed
- Surcharge should also show on invoice creation after updating quantities 

## [7.0.0] - 2018-04-04
### Fixed
- Surcharge entry box should also show on creditmemo creation after updating quantities
- Use extension attribute from registry to stay in sync with calculation
Constructor change in Fooman\Surcharge\Model\Total\Quote\Surcharge

## [6.0.3] - 2018-04-03
### Fixed
- Correct subtotal on address depends on context

## [6.0.2] - 2018-03-12
### Fixed
- GroupSourceInterface is only available in later versions, use implementation instead

## [6.0.1] - 2018-03-06
### Fixed
- Group config can sometimes already be an array

## [6.0.0] - 2018-03-06
### Added
- Ability to restrict surcharges based on min/max amount and groups
Constructor change in Model\SurchargeCalculation
Constructor change in Block\Adminhtml\Surcharge\Edit\Tab\General
- Ability to configure Surcharge Amount while refunding
Constructor change in Model\Total\Creditmemo\Surcharge
Constructor change in Block\Adminhtml\Sales\Order\Creditmemo\Totals\Create

## [5.0.7] - 2018-02-12
### Added
- Workaround for Magento missing tax amounts on invoices/creditmemos that are not last

## [5.0.6] - 2018-02-07
### Added
- Workaround as Magento's subtotal is inconsistent on some tax configurations

## [5.0.5] - 2018-01-25
### Fixed
- Pull in latest fix for Temando Shipping

## [5.0.4] - 2018-01-25
### Fixed
- Reset by Quote as AddressIds change
- Calculate on all address types not just shipping

## [5.0.3] - 2018-01-25
### Fixed
- Reset all surcharges in DB before calculating

## [5.0.2] - 2018-01-25
### Added
- Workaround for Aheadworks OneStepCheckout

## [5.0.1] - 2018-01-22
### Fixed
- Pull in latest fixes from Fooman Totals 5.1.1+

## [5.0.0] - 2018-01-19
### Changed
- Reflect deleted/deactivated Surcharges immediately
- Removed unused param from Quote/Surcharge constructor

## [4.0.2] - 2017-10-12
### Changed
- Cover more invoicing/refunding workflows

## [4.0.1] - 2017-09-18
### Fixed
- Keep compatible with Magento 2.1

## [4.0.0] - 2017-09-17
### Added
- Support for PHP 7.1
- Support for Magento 2.2.0
- Surcharge Sales Total display is now configurable (tax excl/incl) 
### Changed
- Block constructor signature change
- Removed now obsolete TaxTotals block classes

## [3.1.0] - 2017-08-08
### Added
- Display detailed breakdown of surcharges instead of summary

## [3.0.5] - 2017-08-04
### Fixed
- Integration test with multiple products

## [3.0.4] - 2017-08-04
- No Changes since 3.0.1

## [3.0.1] - 2017-08-04
### Changed
- Moved order total update logic into Fooman_Totals
### Fixed
- Don't display 0.00 Surcharge unless configured

## [3.0.0] - 2017-07-31
### Added
- Checkout Tax Display Options
### Fixed
- Display store name in surcharge grid
- Surcharge is only added to first invoice or creditmemo
### Changed
- Api/SurchargeInterface added methods
- Sales total blocks now use TotalManagement classes instead of resource models
- Surcharge collect() now expects an array
- removed Fooman\Surcharge\Model\Type\Total\AbstractTotal
- Model/Totals - privatised properties

## [2.0.0] - 2017-07-12
### Changed
- Implement MEQP2 suggestions - privatised properties
- Renamed UI Component name surcharge to fooman_surcharge to prevent possible conflicts
### Added
- Ability to tax surcharges

## [1.2.2] - 2017-06-14
### Changed
- Updated Fooman Totals

## [1.2.1] - 2017-06-12
### Added
- Small helper to reset existing total

## [1.2.0] - 2017-06-12
### Added
- Moved calculation logic into Surcharge Core

## [1.1.1] - 2017-06-08
### Fixed
- Minor Code Style

## [1.1.0] - 2017-06-08
### Added
- Multi currency support
- Surcharges can be set for all stores

## [1.0.8] - 2017-05-09
### Fixed
- Code released in wrong release number

## [1.0.7] - 2017-05-09
### Fixed
- Name of Observer Class

## [1.0.6] - 2017-04-26
### Changed
- Removed inoperational quick edit

## [1.0.5] - 2017-04-25
### Added
- Fooman Surcharge css class

## [1.0.4] - 2017-04-20
### Fixed
- work with updated extension attribute naming
### Added
- Paypal Support

## [1.0.3] - 2017-04-19
### Fixed
- improve stability if no surcharge types installed

## [1.0.2] - 2017-04-18
### Fixed
- base total amount for quotes

## [1.0.1] - 2017-04-18
### Changed
- Code quality improvements

## [1.0.0] - 2017-04-17
### Added
- Surcharge in Pdf Display
- Surcharging functionality for invoice and creditmemos

## [0.9.0] - 2017-01-23
### Added
- First Release
