<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Ui\DataProvider;

use Fooman\Surcharge\Model\ResourceModel\Surcharge\CollectionFactory;
use Fooman\ProductFees\Model\ProductType;
use Magento\Catalog\Model\Locator\LocatorInterface;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Ui\Component\Container;
use Magento\Ui\Component\DynamicRows;
use Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\AbstractModifier;
use Magento\Ui\Component\Form\Element\DataType\Price;
use Magento\Ui\Component\Form\Element\DataType\Text;
use Magento\Ui\Component\Form\Element\Input;
use Magento\Ui\Component\Form\Element\Select;
use Magento\Ui\Component\Form\Field;

class ProductOptionsModifier extends AbstractModifier
{
    /**
     * @var LocatorInterface
     */
    private $locator;

    /**
     * @var ArrayManager
     */
    private $arrayManager;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        LocatorInterface $locator,
        ArrayManager $arrayManager,
        CollectionFactory $collectionFactory
    ) {
        $this->locator = $locator;
        $this->arrayManager = $arrayManager;
        $this->collectionFactory = $collectionFactory;
    }

    private function getMetaData()
    {
        return [
            'arguments' => [
                'data' => [
                    'config' => [
                        'additionalClasses'=>'fooman_surcharge',
                        'addButtonLabel' => __('Add'),
                        'addButton' => true,
                        'componentType' => DynamicRows::NAME,
                        'component' => 'Magento_Ui/js/dynamic-rows/dynamic-rows',
                        'renderDefaultRecord' => false,
                        'recordTemplate' => 'record',
                        'sortOrder' => 999,
                        'dataScope' => '',
                        'required' => false,
                        'dndConfig' => [
                            'enabled' => false,
                        ],
                    ],
                ],
            ],
            'children' => [
                'record' => [
                    'arguments' => [
                        'data' => [
                            'config' => [
                                'componentType' => Container::NAME,
                                'component' => 'Magento_Ui/js/dynamic-rows/record',
                                'isTemplate' => true,
                                'is_collection' => true,
                            ],
                        ],
                    ],
                    'children' => [
                        'linked_surcharge_id' => [
                            'arguments' => [
                                'data' => [
                                    'config' => [
                                        'dataType' => Text::NAME,
                                        'formElement' => Select::NAME,
                                        'componentType' => Field::NAME,
                                        'dataScope' => 'linked_surcharge_id',
                                        'label' => __('Linked Surcharge'),
                                        'options' => $this->getConfiguredSurcharges(),
                                        'sortOrder' => 20,
                                    ],
                                ],
                            ],
                        ],
                        'type' => [
                            'arguments' => [
                                'data' => [
                                    'config' => [
                                        'dataType' => Text::NAME,
                                        'formElement' => Select::NAME,
                                        'componentType' => Field::NAME,
                                        'dataScope' => 'type',
                                        'label' => __('Type'),
                                        'options' => $this->getModifierTypes(),
                                        'sortOrder' => 30,
                                    ],
                                ],
                            ],
                        ],
                        'amount' => [
                            'arguments' => [
                                'data' => [
                                    'config' => [
                                        'componentType' => Field::NAME,
                                        'formElement' => Input::NAME,
                                        'dataType' => Price::NAME,
                                        'label' => __('Amount'),
                                        'enableLabel' => true,
                                        'dataScope' => 'amount',
                                        'addbefore' => $this->locator->getStore()
                                                                     ->getBaseCurrency()
                                                                     ->getCurrencySymbol(),
                                        'sortOrder' => 40,
                                        'validation' => [
                                            'required-entry' => false
                                        ]
                                    ],
                                ],
                            ],
                        ],
                        'actionDelete' => [
                            'arguments' => [
                                'data' => [
                                    'config' => [
                                        'componentType' => 'actionDelete',
                                        'dataType' => Text::NAME,
                                        'label' => '',
                                        'sortOrder' => 50,
                                    ],
                                ],
                            ],
                        ],
                    ]
                ]
            ]
        ];
    }

    public function getModifierTypes()
    {
        $optionArray = [];
        $optionArray[] = [
            'value' => ProductType::MOD_DIRECT,
            'label' => __('Product')
        ];

        $collection = $this->collectionFactory->create();
        $collection->addFieldToFilter('type', ['neq' => 'product_surcharge']);
        if ($collection->getSize()) {
            $optionArray[] = [
                'value' => ProductType::MOD_EXCLUDE,
                'label' => __('Exclude Product')
            ];
            $optionArray[] = [
                'value' => ProductType::MOD_INCLUDE,
                'label' => __('Include Product')
            ];
            $optionArray[] = [
                'value' => ProductType::MOD_CANCEL_ONE,
                'label' => __('Single item in cart cancels')
            ];
            $optionArray[] = [
                'value' => ProductType::MOD_CANCEL_ALL,
                'label' => __('Only cancel if all items cancel')
            ];
        }

        return $optionArray;
    }

    private function getConfiguredSurcharges()
    {
        $optionArray = [];
        $collection = $this->collectionFactory->create();
        foreach ($collection as $surcharge) {
            //This check guards against surcharges configured by surcharge extensions no longer present
            if ($surcharge->getTypeInstance()) {
                $optionArray[] = [
                    'value' => $surcharge->getId(),
                    'label' => $surcharge->getDescription() . ' [' . $surcharge->getTypeInstance()->getLabel() . ']'
                ];
            }
        }

        return $optionArray;
    }

    /**
     * @param array $data
     *
     * @return array
     */
    public function modifyData(array $data)
    {
        return $data;
    }

    /**
     * @param array $meta
     *
     * @return array
     */
    public function modifyMeta(array $meta)
    {
        $containerPath = $this->arrayManager->findPath(
            'fooman_productsurcharge_mods',
            $meta,
            null,
            'children'
        );

        return $this->arrayManager->merge(
            $containerPath,
            $meta,
            $this->getMetaData()
        );
    }
}
