<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Setup\Patch\Data;

use Fooman\ProductFees\Model\Product\Backend\SurchargeModifier;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddProductAttribute implements DataPatchInterface
{
    const FOOMAN_PRODUCTSURCHARGE_MODS = 'fooman_productsurcharge_mods';

    /**
     * @var ModuleDataSetupInterface $moduleDataSetup
     */
    private $moduleDataSetup;

    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * @return AddProductAttribute
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Zend_Validate_Exception
     */
    public function apply()
    {
        /** @var \Magento\Eav\Setup\EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        $surchargeAttr = $eavSetup->getAttribute(Product::ENTITY, self::FOOMAN_PRODUCTSURCHARGE_MODS);

        if (!$surchargeAttr) {
            $eavSetup->addAttribute(
                Product::ENTITY,
                self::FOOMAN_PRODUCTSURCHARGE_MODS,
                [
                    'label' => 'Product Fees',
                    'group' => 'Advanced Pricing',
                    'type' => 'decimal',
                    'input' => 'text',
                    'backend' => SurchargeModifier::class,
                    'note' => '',
                    'required' => false,
                    'global' => ScopedAttributeInterface::SCOPE_GLOBAL,
                    'visible' => true,
                    'is_used_in_grid' => false,
                    'is_visible_in_grid' => false,
                    'used_in_product_listing' => true,
                    'sort_order' => 100,
                    'apply_to' => 'simple,virtual,downloadable',
                ]
            );
        }
        return $this;
    }

    public function revert()
    {
        /** @var \Magento\Eav\Setup\EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);
        $eavSetup->removeAttribute(Product::ENTITY, self::FOOMAN_PRODUCTSURCHARGE_MODS);
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }
}
