<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Plugin;

use Fooman\Surcharge\Helper\SurchargeConfig;
use Fooman\ProductFees\Model\SurchargeModifierRepository;

class ProductExcluder
{
    private $modifierRepository;

    private $surchargeConfigHelper;

    public function __construct(
        SurchargeModifierRepository $surchargeModifierRepo,
        SurchargeConfig $surchargeConfigHelper
    ) {
        $this->modifierRepository = $surchargeModifierRepo;
        $this->surchargeConfigHelper = $surchargeConfigHelper;
    }

    public function afterShouldItemCountTowardsTotal(
        \Fooman\Surcharge\Model\SurchargeCalculation $subject,
        $result,
        $item,
        \Fooman\Surcharge\Api\SurchargeInterface $surcharge
    ) {
        //The default implementation is to count all items
        //if it was changed by some other process we will not run product exclusion logic
        if (!$result) {
            return $result;
        }
        $config = $this->surchargeConfigHelper->getConfig($surcharge);
        if ($config->getProductDefaultMode() === 'excluded') {
            return $this->modifierRepository->checkIfIncluded($surcharge->getId(), $item->getProductId());
        }
        return !$this->modifierRepository->checkIfExcluded($surcharge->getId(), $item->getProductId());
    }
}
