<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Plugin;

use Fooman\ProductFees\Model\SurchargeModifierRepository;

class CancelSurcharge
{
    private $modifierRepository;

    public function __construct(
        SurchargeModifierRepository $surchargeModifierRepo
    ) {
        $this->modifierRepository = $surchargeModifierRepo;
    }

    public function afterSurchargeApplies(
        \Fooman\Surcharge\Model\SurchargeRestrictor $subject,
        $result,
        \Magento\Quote\Api\Data\CartInterface $quote,
        \Fooman\Surcharge\Model\SurchargeConfig $config,
        $total
    ) {
        if (!$result) {
            return $result;
        }

        if (!$this->isApplicableForCart($quote, $config)) {
            return false;
        }

        return $this->modifierRepository->checkIfAppliesAfterCancellations($config->getSurchargeId(), $quote);
    }

    /**
     * @param \Magento\Quote\Api\Data\CartInterface $quote
     * @param \Fooman\Surcharge\Model\SurchargeConfig $config
     * @return bool
     */
    private function isApplicableForCart(
        \Magento\Quote\Api\Data\CartInterface $quote,
        \Fooman\Surcharge\Model\SurchargeConfig $config
    ) {
        $cartQualifies = true;
        if ($config->getProductDefaultMode() === 'excluded'
            || $config->getProductDefaultMode() === 'included_after_trigger'
        ) {
            $cartQualifies = $this->isApplicableForCartInExclusiveMode($quote, $config);
        }
        return $cartQualifies;
    }

    /**
     * @param \Magento\Quote\Api\Data\CartInterface $quote
     * @param \Fooman\Surcharge\Model\SurchargeConfig $config
     * @return bool
     */
    private function isApplicableForCartInExclusiveMode(
        \Magento\Quote\Api\Data\CartInterface $quote,
        \Fooman\Surcharge\Model\SurchargeConfig $config
    ) {
        $allItems = $quote->getItems();
        if ($allItems) {
            foreach ($allItems as $item) {
                if ($this->modifierRepository->checkIfIncluded($config->getSurchargeId(), $item->getProductId())) {
                    return true;
                }
            }
        }
        return false;
    }
}
