<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Observer;

use Fooman\ProductFees\Model\SurchargeModifierRepository;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class MassUpdate implements ObserverInterface
{
    private $modifierRepository;

    public function __construct(
        SurchargeModifierRepository $surchargeModifierRepo
    ) {
        $this->modifierRepository = $surchargeModifierRepo;
    }

    public function execute(Observer $observer)
    {
        $attrData = $observer->getEvent()->getAttributesData();
        $productIds = $observer->getEvent()->getProductIds();
        if (isset($attrData['fooman_productsurcharge_mods'])) {
            $activeSurcharges = array_filter($attrData['fooman_productsurcharge_mods'], function ($v) {
                return (isset($v['enabled']) && $v['enabled'] == '1');
            });
            foreach ($productIds as $productId) {
                $this->saveIndividualProduct($activeSurcharges, $productId);
            }
            unset($attrData['fooman_productsurcharge_mods']);
            $observer->getEvent()->setAttributesData($attrData);
        }
    }

    private function saveIndividualProduct($data, $productId)
    {
        $this->modifierRepository->save($data, $productId);
    }
}
