<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Model;

class SurchargeModifier extends \Magento\Framework\Model\AbstractModel
{

    const KEY_LINKED_SURCHARGED_ID = 'linked_surcharge_id';
    const KEY_LINKED_PRODUCT_ID = 'linked_product_id';
    const KEY_TYPE = 'type';
    const KEY_AMOUNT = 'amount';

    //phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore -- Magento Core Use
    protected function _construct()
    {
        $this->_init(ResourceModel\SurchargeModifier::class);
    }

    public function setLinkedSurchargeId($linkedSurchargeId)
    {
        $this->setData(self::KEY_LINKED_SURCHARGED_ID, $linkedSurchargeId);
    }

    public function getLinkedSurchargeId()
    {
        return $this->getData(self::KEY_LINKED_SURCHARGED_ID);
    }

    public function setLinkedProductId($linkedProdId)
    {
        $this->setData(self::KEY_LINKED_PRODUCT_ID, $linkedProdId);
    }

    public function getLinkedProductId()
    {
        return $this->getData(self::KEY_LINKED_PRODUCT_ID);
    }

    public function setType($type)
    {
        $this->setData(self::KEY_TYPE, $type);
    }

    public function getType()
    {
        return $this->getData(self::KEY_TYPE);
    }

    public function setAmount($amount)
    {
        $this->setData(self::KEY_AMOUNT, $amount);
    }

    public function getAmount()
    {
        return $this->getData(self::KEY_AMOUNT);
    }
}
