<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Model\Product\Backend;

use Fooman\ProductFees\Model\SurchargeModifierRepository;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\EntityManager\Operation\ExtensionInterface;

class SurchargeModifierHandler implements ExtensionInterface
{

    private $metadataPool;
    private $modifierRepository;

    public function __construct(
        MetadataPool $metadataPool,
        SurchargeModifierRepository $surchargeModifierRepo
    ) {
        $this->metadataPool = $metadataPool;
        $this->modifierRepository = $surchargeModifierRepo;
    }

    public function execute($product, $arguments = [])
    {
        $this->modifierRepository->save($product->getFoomanProductsurchargeMods(), $product->getId());
        return $product;
    }
}
