<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Block;

use Fooman\ProductFees\Model\ProductType;
use Magento\Framework\Module\ModuleList;
use Magento\Shipping\Model\Config\Source\Allmethods;

class ProductTab extends \Magento\Backend\Block\Widget\Form\Generic
{

    /**
     * @var Allmethods
     */
    private $shippingMethodsSource;

    /**
     * @var ModuleList
     */
    private $moduleList;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        Allmethods $shippingMethodsSource,
        ModuleList $moduleList,
        array $data = []
    ) {
        $this->shippingMethodsSource = $shippingMethodsSource;
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Product Fees Settings')]);

        $fieldset->addField(
            'type',
            'select',
            [
                'label' => __('Type'),
                'title' => __('Type'),
                'name' => 'type',
                'required' => true,
                'options' => [
                    ProductType::PER_ORDER => __('Per Order'),
                    ProductType::PER_PRODUCT => __('Per Product'),
                    ProductType::PER_ITEM => __('Per Item'),
                ]
            ]
        );

        $fieldset->addField(
            'max_fixed',
            'text',
            [
                'label' => __('Maximum Surcharge'),
                'title' => __('Maximum Surcharge'),
                'name' => 'max_fixed',
                'required' => false,
            ]
        );

        $fieldset->addField(
            'max_item_multiplier',
            'text',
            [
                'label' => __('Maximum Times Applied'),
                'title' => __('Maximum Times Applied'),

                'name' => 'max_item_multiplier',
                'required' => false,
            ]
        );

        if ($this->moduleList->has('Fooman_SurchargeShipping')) {
            $fieldset->addField(
                'apply_shipping_filter',
                'select',
                [
                    'label' => __('Apply Shipping Method Filter'),
                    'title' => __('Apply Shipping Method Filter'),
                    'name' => 'apply_shipping_filter',
                    'required' => false,
                    'options' => [
                        0 => __('No'),
                        1 => __('Yes'),
                    ]
                ]
            );

            $fieldset->addField(
                'shipping',
                'multiselect',
                [
                    'label' => __('Shipping Methods'),
                    'title' => __('Shipping Methods'),
                    'name' => 'shipping[]',
                    'required' => false,
                    'values' => $this->getListOfShippingMethods()
                ]
            );
        }

        if ($this->_coreRegistry->registry('fooman_surcharge')) {
            $registry = $this->_coreRegistry->registry('fooman_surcharge');
            if ($registry->getDataRule()) {
                $formData = json_decode($registry->getDataRule(), true);
                $form->addValues($formData);
            }
        }

        $form->setFieldNameSuffix('product_surcharge');
        $this->setForm($form);
        return $this;
    }

    private function getListOfShippingMethods()
    {
        $isActiveOnlyFlag = false;
        if ($this->moduleList->has('Temando_Shipping')) {
            //If Temando_Shipping is present in 2.2 getting a list of shipping methods causes
            //BadMethodCallException: Missing required argument $offset of Temando\Shipping\Rest\Request\ListRequest.
            //Temando is being shut down 29.10.2019
            $isActiveOnlyFlag = true;
        }
        return $this->shippingMethodsSource->toOptionArray($isActiveOnlyFlag);
    }
}
