<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Block;

use Fooman\ProductFees\Model\ProductType;
use Magento\Framework\Module\ModuleList;
use Magento\Shipping\Model\Config\Source\Allmethods;

class MinSpendTab extends \Magento\Backend\Block\Widget\Form\Generic
{

    /**
     * @var Allmethods
     */
    private $shippingMethodsSource;

    /**
     * @var ModuleList
     */
    private $moduleList;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        Allmethods $shippingMethodsSource,
        ModuleList $moduleList,
        array $data = []
    ) {
        $this->shippingMethodsSource = $shippingMethodsSource;
        $this->moduleList = $moduleList;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    // phpcs:ignore PSR2.Methods.MethodDeclaration -- Magento 2 core use
    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('general', ['legend' => __('Minimum Product Spend Settings')]);

        $fieldset->addField(
            'max_fixed',
            'text',
            [
                'label' => __('Minimum Spend'),
                'title' => __('Minimum Spend'),
                'name' => 'max_fixed',
                'required' => false,
            ]
        );

        if ($this->_coreRegistry->registry('fooman_surcharge')) {
            $registry = $this->_coreRegistry->registry('fooman_surcharge');
            if ($registry->getDataRule()) {
                $formData = json_decode($registry->getDataRule(), true);
                $form->addValues($formData);
            }
        }

        $form->setFieldNameSuffix('product_min_spend');
        $this->setForm($form);
        return $this;
    }
}
