<?php
/**
 * @copyright Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\ProductFees\Block;

use Fooman\ProductFees\Model\ProductType;
use Fooman\ProductFees\Ui\DataProvider\ProductOptionsModifier;
use Fooman\Surcharge\Model\ResourceModel\Surcharge\CollectionFactory;
use Magento\Framework\Data\Form\Element\CollectionFactory as ElementCollectionFactory;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Escaper;

class FormRenderer extends \Magento\Framework\Data\Form\Element\Text
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var ProductOptionsModifier
     */
    private $productOptionsModifier;

    public function __construct(
        Factory $factoryElement,
        ElementCollectionFactory $factoryCollection,
        Escaper $escaper,
        CollectionFactory $collectionFactory,
        ProductOptionsModifier $productOptionsModifier,
        $data = []
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->productOptionsModifier = $productOptionsModifier;

        parent::__construct($factoryElement, $factoryCollection, $escaper, $data);
    }

    private function getConfiguredSurcharges()
    {
        return $this->collectionFactory->create();
    }

    private function renderSingleSurcharge($surcharge)
    {
        //This check guards against surcharges configured by surcharge extensions no longer present
        if (!$surcharge->getTypeInstance()) {
            return '';
        }
        $linkedId = $surcharge->getId();
        return '<tr><td>'.$surcharge->getDescription().'</td>'
            .'<td>'. $this->getActiveSelect($this->getName() . '['.$linkedId.'][enabled]').'</td>'
            .'<td>'. $this->getTypeSelect(
                $surcharge->getTypeId(),
                $linkedId,
                $this->getName() . '['.$linkedId.'][type]'
            ).'</td>'
            .'<td>'. $this->getAmountInput($linkedId)
            .$this->getHiddenLinkedSurchargeInput(
                $linkedId,
                $this->getName() . '['.$linkedId.'][linked_surcharge_id]'
            ).'</td>'
            .'</tr>';
    }

    private function getAmountInput($linkedId)
    {
        return '<input id="' . $this->getHtmlId().'_amount_'.$linkedId
            . '" name="' . $this->getName() . '['.$linkedId.'][amount]" '
            . $this->_getUiId('_'.$linkedId) . 'class=" input-text admin__control-text" disabled="1"'
            . ' value="" ' . $this->serialize($this->getHtmlAttributes()) . '/>';
    }

    private function getHiddenLinkedSurchargeInput($id, $name)
    {
        return sprintf(
            '<input disabled="1" id="%s" value="%s" name="%s" type="hidden"/>',
            $this->getHtmlId().'_linked_surcharge_id_'.$id,
            $id,
            $name
        );
    }

    private function getTypeSelect($typeId, $id, $name)
    {
        if (strpos($typeId, 'product') === 0) {
            $types = [[
                'value' => ProductType::MOD_DIRECT,
                'label' => __('Product')
            ]];
        } else {
            $types = $this->productOptionsModifier->getModifierTypes();
        }

        $html = '';
        $html .= sprintf('<select id="%s" disabled="1" name="%s">', $this->getHtmlId().'_type_'.$id, $name);
        foreach ($types as $type) {
            $html  .= sprintf('<option value="%s">%s</option>', $type['value'], $type['label']);
        }
        $html .= '</select>';
        return $html;
    }

    private function getActiveSelect($name)
    {
        $html = '<span class="attribute-change-checkbox">';
        $html .= sprintf('<input name="%s" value="1" type="checkbox" aria-label="%s" />', $name, __('Enable'));
        $html .= '</span>';
        return $html;
    }

    public function getElementHtml()
    {
        $surcharges = $this->getConfiguredSurcharges();
        if ($surcharges->count() == 0) {
            return (string)__('No Surcharges configured yet.');
        }

        $htmlId = $this->getHtmlId();
        $html = '<div><table width="100%">';
        $html .= '<tr style="line-height: 200%">';
        $html .= '<th align="left">'.__('Linked Surcharge').'</th>';
        $html .= '<th align="left">'.__('Enable').'</th>';
        $html .= '<th align="left">'.__('Type').'</th>';
        $html .= '<th align="left">'.__('Amount').'</th>';
        $html .= '</tr>';

        $toggles = [];
        foreach ($surcharges as $surcharge) {
            $id = $surcharge->getId();
            $toggles[] = sprintf("toogleFieldEditMode(this, '%s')", $this->getHtmlId().'_amount_'.$id);
            $toggles[] = sprintf("toogleFieldEditMode(this, '%s')", $this->getHtmlId().'_type_'.$id);
            $toggles[] = sprintf("toogleFieldEditMode(this, '%s')", $this->getHtmlId().'_linked_surcharge_id_'.$id);
            $html .= $this->renderSingleSurcharge($surcharge);
        }
        $html .= '</table>';

        if ($afterElementJs = $this->getAfterElementJs()) {
            $html .= $afterElementJs;
        }

        $nameAttributeHtml = 'name="' . $htmlId . '_checkbox"';
        $dataCheckboxName = "toggle_".$htmlId;

        $html .= '<label class="addafter"><span class="attribute-change-checkbox">';

        $html .= sprintf(
            '<input type="checkbox" id="%s" name="%s" class="checkbox" onclick="%s" %s/>',
            $dataCheckboxName,
            $dataCheckboxName,
            implode(';', $toggles),
            $nameAttributeHtml
        );

        $html .= sprintf('<label class="label" for="%s">%s</label>', $dataCheckboxName, __('Change'));
        $html .= '</div>';
        return $html;
    }
}
