/*
 * @copyright Copyright (c) 2015 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

define(
    [
        'uiComponent',
        '../model/list',
        '../action/set-selected-orderfees',
        '../action/get-available-orderfees',
        '../model/messages'
    ],
    function (Component, list, setSelectOrderFees, getAvailableOrderFees, messageContainer) {
        "use strict";

        return Component.extend({
            defaults: {
                template: 'Fooman_OrderFees/checkout/list-after'
            },
            selfLocation: 'afterPaymentMethods',
            orderFeeHeading: window.checkoutConfig.foomanOrderFeesConfig.title,
            selectedOrderFees: list.getSelectedOrderFees(),
            getOrderFeeOptions: function() {
                return list.getAvailableOrderFees();
            },
            isDisplayedBefore: function() {
                return window.checkoutConfig.foomanOrderFeesConfig.display_area == 'beforePaymentMethods';
            },
            isDisplayedAfter: function() {
                return window.checkoutConfig.foomanOrderFeesConfig.display_area == 'afterPaymentMethods';
            },
            isDisplayedBeforeShipping: function() {
                return window.checkoutConfig.foomanOrderFeesConfig.display_area == 'beforeShippingMethods';
            },
            loadAvailableOrderFees: function() {
                if (this.isDisplayedAfter()) {
                    getAvailableOrderFees();
                    this.setUpSubscriber();
                }
            },
            setUpSubscriber: function() {
                list.getSelectedOrderFees().subscribe(function(changes) {
                    setSelectOrderFees(messageContainer);
                }, null, 'arrayChange');
            },
            initialize: function () {
                this._super();
                this.loadAvailableOrderFees();
                return this;
            },
        });
    }
);
