/*
 * @copyright Copyright (c) 2015 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

define(
    [
        './list',
        '../action/get-available-orderfees'
    ],
    function (list, getAvailableOrderFees) {
        "use strict";

        return list.extend({
            defaults: {
                template: 'Fooman_OrderFees/checkout/list-before'
            },
            loadAvailableOrderFees: function() {
                if (this.isDisplayedBefore()) {
                    getAvailableOrderFees();
                    this.setUpSubscriber();
                }
            },
        });
    }
);
